/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import canvas.CoordsCanvas;
import canvas.PopupMenu;
import geoobj.GPoint;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import geoobj.Messages;
import javax.swing.JMenuItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import terms.TermTree;
import xml.Helpers;

public class GPointWDC
extends GPoint {
    public TermTree xTerm = null;
    public TermTree yTerm = null;
    private String bufXTermStr = "";
    private String bufYTermStr = "";

    public GPointWDC(GeoObjList list, String itx, String ity, boolean isVisible) {
        super(list, 0.0, 0.0, isVisible);
        this.appearance.setPointStyle(33);
        this.xTerm = new TermTree(itx, 0.0, this.drawing, TermTree.isRadMode);
        this.yTerm = new TermTree(ity, 0.0, this.drawing, TermTree.isRadMode);
        this.xTerm.registerTermParentsIn(this);
        this.yTerm.registerTermParentsIn(this);
        this.ccMask = 2;
        this.updateParams(null, 0.0, 0.0);
    }

    public GPointWDC(GeoObjList list) {
        super(list);
        this.ccMask = 2;
    }

    public GPointWDC(Element objElem, GeoObjList list) {
        super(objElem, list);
        this.ccMask = 2;
        Element childElem = Helpers.getChildElementByName("position", objElem);
        if (childElem != null) {
            this.bufXTermStr = childElem.hasAttribute("x_term") ? childElem.getAttribute("x_term").trim() : new Double(this.x).toString();
            this.bufYTermStr = childElem.hasAttribute("y_term") ? childElem.getAttribute("y_term").trim() : new Double(this.y).toString();
        }
    }

    @Override
    public Element createDomNode(Document domDoc) {
        Element domData = super.createDomNode(domDoc);
        Element pos = Helpers.getChildElementByName("position", domData);
        pos.setAttribute("x_term", Helpers.maskDelimiters(this.getXTerm()));
        pos.setAttribute("y_term", Helpers.maskDelimiters(this.getYTerm()));
        return domData;
    }

    @Override
    public void afterLoading(CoordsCanvas canvas) {
        this.xTerm = new TermTree(this.bufXTermStr, 0.0, this.drawing, TermTree.isRadMode);
        this.yTerm = new TermTree(this.bufYTermStr, 0.0, this.drawing, TermTree.isRadMode);
        this.xTerm.registerTermParentsIn(this);
        this.yTerm.registerTermParentsIn(this);
    }

    @Override
    public void addToContextMenu(PopupMenu menu) {
        super.addToContextMenu(menu);
        menu.add2List(null, 0);
        menu.add2List(new JMenuItem(Messages.getString("GPointWDC.menu_editcoords")), 67);
    }

    public String getXTerm() {
        return this.xTerm.getTermString();
    }

    public String getYTerm() {
        return this.yTerm.getTermString();
    }

    public void setXTerm(String ns) {
        this.xTerm.unregisterTermParentsIn(this);
        this.xTerm.buildTermTree(ns, 0.0);
        this.xTerm.registerTermParentsIn(this);
    }

    public void setYTerm(String ns) {
        this.yTerm.unregisterTermParentsIn(this);
        this.yTerm.buildTermTree(ns, 0.0);
        this.yTerm.registerTermParentsIn(this);
    }

    @Override
    public boolean hasSameDataAs(GeoObj o) {
        if (this.xTerm == null || this.yTerm == null) {
            return false;
        }
        return o.getClass().equals(GPointWDC.class) && ((GPointWDC)o).xTerm.hasSameDataAs(this.xTerm) && ((GPointWDC)o).yTerm.hasSameDataAs(this.yTerm);
    }

    @Override
    public void updateParams(GeoObj mousedObj, double lmx, double lmy) {
        this.x = this.xTerm.getValue(0.0);
        this.y = this.yTerm.getValue(this.x);
        this.setValid(this.xTerm.isOkay() && this.yTerm.isOkay());
    }
}

