/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import dgmath.MyMath;
import dgmath.Vector3;
import geoobj.GCircle;
import geoobj.GConic;
import geoobj.GLine;
import geoobj.GLineObj;
import geoobj.GPoint;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import org.w3c.dom.Element;

public class GPolar
extends GLine {
    public GPolar(GeoObjList list, GeoObj iPL, GeoObj iConic, boolean isVisible) {
        super(list, iPL, iConic, isVisible);
    }

    public GPolar(GeoObjList list) {
        super(list);
    }

    public GPolar(Element objElem, GeoObjList list) {
        super(objElem, list);
    }

    @Override
    public void updateParams(GeoObj mousedObj, double mx, double my) {
        this.setValid(false);
        GPoint pp = (GPoint)this.parent.get(0);
        GLineObj coc = (GLineObj)this.parent.get(1);
        if (pp != null && pp.isValid() && coc != null && coc.isValid()) {
            double[] coeff = null;
            if (coc instanceof GCircle) {
                coeff = ((GCircle)coc).getConicEquation();
            } else if (coc instanceof GConic) {
                coeff = ((GConic)coc).getEq();
            }
            if (coeff != null) {
                Vector3 res = MyMath.getPolareFromPolAndConic(pp.x, pp.y, coeff);
                this.eq[0] = res.x;
                this.eq[1] = res.y;
                this.eq[2] = -res.z;
                this.setValid(true);
            }
        }
    }
}

