/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import applet.InpItemList;
import canvas.CoordsCanvas;
import dgmath.MyMath;
import dgmath.V3List;
import dgmath.Vector3;
import geoobj.GArea;
import geoobj.GCurve;
import geoobj.GPoint;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import geoobj.RelationList;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xml.Helpers;

public class GPolygon
extends GCurve {
    protected double[] polyCOG = new double[]{0.0, 0.0};
    protected double polyArea = 0.0;

    public GPolygon(GeoObjList list, InpItemList vertices) {
        super(list);
        this.ccMask = this.ccMask | 0x20000 | 0x10000;
        if (vertices != null) {
            int i = 0;
            while (i < vertices.size()) {
                if (i == 0 || vertices.get((int)i).go.id != vertices.get((int)0).go.id) {
                    this.becomesChildOf(vertices.get((int)i).go);
                }
                ++i;
            }
            this.initPointList();
        }
    }

    public GPolygon(Element objElem, GeoObjList list) {
        super(objElem, list);
        this.ccMask = this.ccMask | 0x20000 | 0x10000;
    }

    @Override
    public void afterLoading(CoordsCanvas canvas) {
        this.initPointList();
        this.updateParams(null, 0.0, 0.0);
    }

    @Override
    public Element createDomNode(Document domDoc) {
        Element domData = super.createDomNode(domDoc);
        Element pos = domDoc.createElement("position");
        pos.setAttribute("x1", "0");
        pos.setAttribute("y1", "0");
        pos.setAttribute("x2", "0");
        pos.setAttribute("y2", "0");
        Element pts = Helpers.getChildElementByName("points", domData);
        domData.replaceChild(pos, pts);
        return domData;
    }

    @Override
    public boolean includes(GPoint pt) {
        return this.dist(pt.x, pt.y) < 1.0E-6;
    }

    @Override
    public double[] getTangentDirIn(double xp, double yp) {
        double p = this.getParamFromCoords(xp, yp);
        int n = (int)Math.floor(p);
        if (n >= 0 && n < this.parent.size()) {
            GPoint p1 = (GPoint)this.parent.get(n);
            GPoint p2 = (GPoint)this.parent.get((n + 1) % this.parent.size());
            double[] dArray = new double[]{p2.getx(0) - p1.getx(0), p2.gety(0) - p1.gety(0)};
            double[] res = dArray;
            double len = MyMath.hypot(res[0], res[1]);
            if (len > 1.0E-6) {
                res[0] = res[0] / len;
                res[1] = res[1] / len;
                return res;
            }
            return null;
        }
        return null;
    }

    @Override
    public double[] getNormalDirIn(double xp, double yp) {
        double p = this.getParamFromCoords(xp, yp);
        int n = (int)Math.floor(p);
        if (n >= 0 && n < this.parent.size()) {
            GPoint p1 = (GPoint)this.parent.get(n);
            GPoint p2 = (GPoint)this.parent.get((n + 1) % this.parent.size());
            double[] dArray = new double[]{p1.gety(0) - p2.gety(0), p2.getx(0) - p1.getx(0)};
            double[] res = dArray;
            double len = MyMath.hypot(res[0], res[1]);
            if (len > 1.0E-6) {
                res[0] = res[0] / len;
                res[1] = res[1] / len;
                return res;
            }
            return null;
        }
        return null;
    }

    @Override
    public String defName() {
        return "N";
    }

    @Override
    public double[] getNameParamsFromCoords(double nx, double ny) {
        double[] res = new double[]{nx - this.polyCOG[0], ny - this.polyCOG[1]};
        return res;
    }

    @Override
    public double[] getNameCoordsFromParams(double[] np) {
        double[] res = new double[]{this.polyCOG[0] + np[0], this.polyCOG[1] + np[1]};
        return res;
    }

    public int getVCount() {
        return this.parent.size();
    }

    @Override
    public double getValue(int select) {
        double res = 0.0;
        switch (select) {
            case 5: {
                res = this.polyArea;
                break;
            }
            case 3: {
                res = MyMath.getPolyCircumf(this.ptList);
                break;
            }
            case 1: {
                res = this.polyCOG[0];
                break;
            }
            case 2: {
                res = this.polyCOG[1];
                break;
            }
            case 0: {
                res = this.parent.size();
                break;
            }
            default: {
                res = super.getValue(select);
            }
        }
        return res;
    }

    @Override
    public boolean canMoveFree() {
        boolean res = true;
        int i = 0;
        while (i < this.parent.size()) {
            if (!this.parent.get(i).canMoveFree()) {
                res = false;
            }
            ++i;
        }
        if (!res) {
            RelationList fvL = new RelationList();
            RelationList dvL = new RelationList();
            RelationList dragL = new RelationList();
            int i2 = 0;
            while (i2 < this.parent.size()) {
                GeoObj go = this.getParent(i2);
                if (go instanceof GPoint && go.parent.size() == 0) {
                    fvL.add(go);
                } else {
                    dvL.add(go);
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < fvL.size()) {
                this.registerObjAndDescendents(fvL.get(i2), dragL, fvL);
                ++i2;
            }
            dragL.sortByDependencies();
            this.check4FixedVertices(dragL, fvL, dvL);
            if (dvL.size() == 0) {
                res = true;
            }
        }
        return res;
    }

    public boolean isFilled() {
        boolean res = false;
        int i = 0;
        while (i < this.child.size()) {
            if (this.child.get(i) instanceof GArea) {
                res = true;
            }
            ++i;
        }
        return res;
    }

    @Override
    public double[] getCoordsFromParam(double param) {
        if (param < 0.0 || param > (double)this.ptList.count()) {
            return new double[]{this.ptList.get((int)0).x, this.ptList.get((int)0).y};
        }
        int i = (int)Math.floor(param);
        double dp = param - (double)i;
        double nx = this.ptList.get((int)i).x;
        double ny = this.ptList.get((int)i).y;
        double mx = this.ptList.get((int)((i + 1) % this.ptList.count())).x;
        double my = this.ptList.get((int)((i + 1) % this.ptList.count())).y;
        nx += dp * (mx - nx);
        ny += dp * (my - ny);
        return new double[]{nx, ny};
    }

    @Override
    public double getParamFromCoords(double px, double py) {
        double[] pt = this.getPtNextTo(px, py);
        return pt[2];
    }

    @Override
    public double[] getParamRange() {
        double[] res = new double[]{0.0, this.getVCount()};
        return res;
    }

    @Override
    public void resetOLCPList(CoordsCanvas canvas, V3List ptList) {
        ptList.clear();
        double[] piv = this.getParamRange();
        double p = piv[0];
        double dp = 0.0625;
        int i = 0;
        while ((double)i <= piv[1] * 16.0) {
            if (ptList.get(i) == null) {
                ptList.insertAt(i, new Vector3(0.0, 0.0, p));
            }
            p += dp;
            ++i;
        }
        ptList.get((int)(ptList.count() - 1)).z = piv[1];
    }

    @Override
    public Shape getBorder(CoordsCanvas canvas) {
        Polygon poly = new Polygon();
        Point2D.Double spt = new Point2D.Double();
        int i = 0;
        while (i < this.ptList.count()) {
            canvas.getScreenPtCoords(this.ptList.get((int)i).x, this.ptList.get((int)i).y, spt);
            poly.addPoint((int)spt.x, (int)spt.y);
            ++i;
        }
        return poly;
    }

    @Override
    public void updateParams(GeoObj mousedObj, double mx, double my) {
        this.fillPointList(null);
        if (this.isValid()) {
            this.polyCOG = MyMath.getPolyCOG(this.ptList);
            this.polyArea = MyMath.getPolyArea(this.ptList);
        }
    }

    @Override
    public void moveBy(double dx, double dy, CoordsCanvas canvas) {
        int i = 0;
        while (i < this.parent.size()) {
            this.parent.get(i).moveBy(dx, dy, canvas);
            this.getDrawing().fillDragList(this.parent.get(i));
            this.getDrawing().updateDraggedObjs(this, dx, dy);
            ++i;
        }
    }

    @Override
    public void draw(CoordsCanvas canvas) {
    }

    @Override
    public void saveState() {
        super.saveState();
        this.stack.pushDouble(this.polyCOG[0]);
        this.stack.pushDouble(this.polyCOG[1]);
        this.stack.pushDouble(this.polyArea);
    }

    @Override
    public void restoreState() {
        this.polyArea = this.stack.popDouble();
        this.polyCOG[1] = this.stack.popDouble();
        this.polyCOG[0] = this.stack.popDouble();
        super.restoreState();
    }

    protected void initPointList() {
        this.ptList.clear();
        int i = 0;
        while (i <= this.parent.size()) {
            GPoint v = (GPoint)this.parent.get(i % this.parent.size());
            this.ptList.insert(new Vector3(v.x, v.y, i));
            ++i;
        }
    }

    @Override
    protected void fillPointList(CoordsCanvas canvas) {
        int i = 0;
        while (i <= this.parent.size()) {
            GPoint v = (GPoint)this.parent.get(i % this.parent.size());
            this.ptList.get(i).assign(v.x, v.y, i);
            ++i;
        }
    }

    protected double[] getPtNextTo(double qx, double qy) {
        double minDist = 1.0E10;
        double[] res = new double[3];
        double[] pts = new double[]{qx, qy, 0.0, 0.0, 0.0, 0.0};
        int i = 0;
        while (i < this.getVCount()) {
            double aDist;
            pts[2] = this.ptList.get((int)i).x;
            pts[3] = this.ptList.get((int)i).y;
            pts[4] = this.ptList.get((int)((i + 1) % this.getVCount())).x;
            pts[5] = this.ptList.get((int)((i + 1) % this.getVCount())).y;
            double[] foot = MyMath.getSegmentParamFromPt(null, pts);
            if (foot[2] >= 0.0) {
                if (foot[2] >= 1.0) {
                    aDist = MyMath.hypot(pts[4] - qx, pts[5] - qy);
                    if (aDist < minDist) {
                        minDist = aDist;
                        res[0] = foot[0];
                        res[1] = foot[1];
                        res[2] = i + 1;
                    }
                } else {
                    aDist = MyMath.hypot(foot[0] - qx, foot[1] - qy);
                    if (aDist < minDist) {
                        minDist = aDist;
                        res[0] = foot[0];
                        res[1] = foot[1];
                        res[2] = (double)i + foot[2];
                    }
                }
            } else {
                aDist = MyMath.hypot(pts[2] - qx, pts[3] - qy);
                if (aDist < minDist) {
                    minDist = aDist;
                    res[0] = foot[0];
                    res[1] = foot[1];
                    res[2] = 0.0;
                }
            }
            ++i;
        }
        return res;
    }

    protected void registerObjAndDescendents(GeoObj go, RelationList dragList, RelationList freeList) {
        if (freeList.indexOf(go) >= 0) {
            dragList.insert(0, go);
        } else {
            dragList.add(go);
        }
        int i = 0;
        while (i < go.getChildrenCount()) {
            this.registerObjAndDescendents(go.getChild(i), dragList, freeList);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void check4FixedVertices(RelationList dragL, RelationList fvL, RelationList dvL) {
        i = 0;
        while (i < this.parent.size()) {
            ((GPoint)this.parent.get(i)).saveState();
            ++i;
        }
        DVData = new ArrayList<TCheck>();
        i = 0;
        while (i < dvL.size()) {
            DVData.add(new TCheck((GPoint)dvL.get(i)));
            ++i;
        }
        try {
            j = 0;
            while (j < 4) {
                d_x = 5.0 * (MyMath.random(0) - 0.5);
                d_y = 5.0 * (MyMath.random(0) - 0.5);
                i = 0;
                while (i < dragL.size() && dragL.get(i).getClass().equals(GPoint.class) && dragL.get(i).getParentCount() == 0) {
                    dragL.get((int)i).x += d_x;
                    dragL.get((int)i).y += d_y;
                    ++i;
                }
                while (i < dragL.size()) {
                    dragL.get(i).updateParams(null, 0.0, 0.0);
                    ++i;
                }
                k = 0;
                while (k < dvL.size()) {
                    ac = (TCheck)DVData.get(k);
                    if (j > 0) {
                        ddr = Math.hypot(ac.go.x - ac.x_old - d_x, ac.go.y - ac.y_old - d_y);
                        ac.dr += ddr;
                    }
                    ac.x_old = ac.go.x;
                    ac.y_old = ac.go.y;
                    ++k;
                }
                ++j;
            }
            i = dvL.size() - 1;
            while (i >= 0) {
                if (((TCheck)DVData.get((int)i)).dr < 1.0E-12) {
                    dvL.remove(((TCheck)DVData.get((int)i)).go);
                }
                --i;
            }
        }
        finally {
            i = 0;
            ** while (i < this.parent.size())
        }
lbl-1000:
        // 1 sources

        {
            ((GPoint)this.parent.get(i)).restoreState();
            ++i;
            continue;
        }
lbl54:
        // 1 sources

        i = 0;
        while (i < dragL.size() && dragL.get(i).getClass().equals(GPoint.class) && dragL.get((int)i).parent.size() == 0) {
            ++i;
        }
        while (i < dragL.size()) {
            dragL.get(i).updateParams(null, 0.0, 0.0);
            ++i;
        }
    }

    class TCheck {
        public GPoint go;
        public double x_old;
        public double y_old;
        public double dr;

        TCheck(GPoint igo) {
            this.go = igo;
            this.x_old = igo.x;
            this.y_old = igo.y;
            this.dr = 0.0;
        }
    }
}

