/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import dgmath.MyMath;
import geoobj.GCircle;
import geoobj.GConic;
import geoobj.GDoubleIntersection;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import java.awt.geom.Point2D;
import org.w3c.dom.Element;

public class GQuadIntersection
extends GDoubleIntersection {
    public GQuadIntersection(GeoObjList list) {
        super(list);
        this.pointList = new Point2D.Double[4];
        this.validList = new boolean[4];
    }

    public GQuadIntersection(GeoObjList list, GeoObj ip1, GeoObj ip2) {
        super(list);
        this.pointList = new Point2D.Double[4];
        this.validList = new boolean[4];
        if (ip1.isCompatibleTo(4096)) {
            this.becomesChildOf(ip1);
            this.becomesChildOf(ip2);
        } else {
            this.becomesChildOf(ip2);
            this.becomesChildOf(ip1);
        }
        this.updateParams(null, 0.0, 0.0);
    }

    public GQuadIntersection(Element objElem, GeoObjList list) {
        super(objElem, list);
        this.pointList = new Point2D.Double[4];
        this.validList = new boolean[4];
    }

    @Override
    public void updateParams(GeoObj mousedObj, double lmx, double lmy) {
        this.setValid(true);
        double[] c1 = this.parent.get(0).isCompatibleTo(8192) ? ((GConic)this.parent.get(0)).getEq() : ((GCircle)this.parent.get(0)).getConicEquation();
        double[] c2 = ((GConic)this.parent.get(1)).getEq();
        double[] res = MyMath.intersectConics(c1, c2);
        int i = 0;
        while (i <= 3) {
            boolean bl = this.validList[i] = res[i * 3 + 2] > 0.5;
            if (this.validList[i]) {
                this.pointList[i] = new Point2D.Double(res[i * 3], res[i * 3 + 1]);
            }
            ++i;
        }
    }

    @Override
    protected String defName() {
        return "QI";
    }
}

