/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import canvas.CoordsCanvas;
import dgmath.MyMath;
import dgmath.V3List;
import dgmath.Vector3;
import geoobj.GLine;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import org.w3c.dom.Element;

public class GRay
extends GLine {
    public GRay(GeoObjList list, GeoObj ip1, GeoObj ip2, boolean isVisible) {
        super(list, ip1, ip2, isVisible);
    }

    public GRay(GeoObjList list) {
        super(list);
    }

    public GRay(Element objElem, GeoObjList list) {
        super(objElem, list);
    }

    @Override
    protected String defName() {
        return "h";
    }

    @Override
    public double dist(double mx, double my) {
        if (this.isValid()) {
            double[] p = new double[]{mx, my};
            Vector3 f = MyMath.getPedalPoint(this.getEq(), p);
            if ((this.x2 - this.x1) * (f.x - this.x1) + (this.y2 - this.y1) * (f.y - this.y1) < 0.0) {
                return MyMath.hypot(mx - this.x1, my - this.y1);
            }
            return super.dist(mx, my);
        }
        return 1.0E20;
    }

    @Override
    public boolean containsPoint(double px, double py) {
        return this.dist(px, py) < 1.0E-6;
    }

    @Override
    public void draw(CoordsCanvas canvas) {
        if (this.isVisible()) {
            canvas.drawRay(this.x1, this.y1, this.x2, this.y2, this.appearance.getPenStyle(), this.appearance.getLineWidth(), this.appearance.getColor());
        }
    }

    @Override
    public void resetOLCPList(CoordsCanvas canvas, V3List ptList) {
        if (canvas != null) {
            double[] range = canvas.getCoordsRange();
            double w = range[2] - range[0];
            double h = range[3] - range[1];
            range[0] = range[0] - w;
            range[1] = range[1] - h;
            range[2] = range[2] + w;
            range[3] = range[3] + h;
            double[] ip = MyMath.intersectLineAndRectangle(this.getEq(), range);
            if (ip[2] + ip[5] > 1.5 && MyMath.hypot(ip[0] - ip[3], ip[1] - ip[4]) > 1.0) {
                double p2;
                double p1 = this.getParamFromCoords(ip[0], ip[1]);
                if (p1 > (p2 = this.getParamFromCoords(ip[3], ip[4]))) {
                    w = p1;
                    p1 = p2;
                    p2 = w;
                }
                if (p2 > 0.0) {
                    if (p1 < 0.0) {
                        p1 = 0.0;
                    }
                    ptList.reset2zList(40, p1, p2);
                } else {
                    ptList.clear();
                }
            } else {
                ptList.reset2zList(30, 0.0, 15.0);
            }
        } else {
            ptList.reset2zList(30, 0.0, 15.0);
        }
    }
}

