/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import canvas.CoordsCanvas;
import dgmath.MyMath;
import dgmath.Vector3;
import geoobj.GPoint;
import geoobj.GPolygon;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xml.Helpers;

public class GRegPoly
extends GPolygon {
    protected int vcount = -1;
    protected double circum = 0.0;
    protected boolean reversed = false;

    public GRegPoly(GeoObjList list, GeoObj p1, GeoObj p2, int iVCount) {
        super(list, null);
        this.becomesChildOf(p1);
        this.becomesChildOf(p2);
        this.vcount = iVCount;
        this.initPointList();
    }

    public GRegPoly(Element objElem, GeoObjList list) {
        super(objElem, list);
        Element pos_Elem = Helpers.getChildElementByName("position", objElem);
        if (pos_Elem.hasAttribute("vcount")) {
            this.vcount = Integer.parseInt(pos_Elem.getAttribute("vcount"));
        }
        if (pos_Elem.hasAttribute("reversed") && pos_Elem.getAttribute("reversed") == "-1") {
            this.reversed = true;
        }
    }

    @Override
    public Element createDomNode(Document domDoc) {
        Element domData = super.createDomNode(domDoc);
        Element pos = Helpers.getChildElementByName("position", domData);
        if (this.getClass() == GRegPoly.class) {
            pos.setAttribute("x1", String.valueOf(this.parent.get((int)0).x));
            pos.setAttribute("y1", String.valueOf(this.parent.get((int)0).y));
            pos.setAttribute("x2", String.valueOf(this.parent.get((int)1).x));
            pos.setAttribute("y2", String.valueOf(this.parent.get((int)1).y));
        }
        pos.setAttribute("vcount", String.valueOf(this.vcount));
        if (this.isReversed()) {
            pos.setAttribute("reversed", "-1");
        }
        return domData;
    }

    @Override
    public int getVCount() {
        return this.vcount;
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    public double[] getVCoords(int n) {
        if (this.isValid() && n >= 0 && n < this.vcount) {
            double[] res = new double[]{this.ptList.get((int)n).x, this.ptList.get((int)n).y};
            return res;
        }
        return null;
    }

    @Override
    public void updateParams(GeoObj mousedObj, double mx, double my) {
        this.fillPointList(null);
        if (this.isValid()) {
            this.circum = (double)this.vcount * MyMath.hypot(this.ptList.get((int)1).x - this.ptList.get((int)0).x, this.ptList.get((int)1).y - this.ptList.get((int)0).y);
            this.polyArea = this.circum * MyMath.distPt2ShortLn(this.ptList.get((int)0).x, this.ptList.get((int)0).y, this.ptList.get((int)1).x, this.ptList.get((int)1).y, this.polyCOG[0], this.polyCOG[1]) / 2.0;
        }
    }

    @Override
    protected void initPointList() {
        int i = 0;
        while (i < 2) {
            GPoint v = (GPoint)this.parent.get(i);
            int nv = 0;
            if (!v.isValid()) {
                nv = -2;
                this.setValid(false);
            }
            this.ptList.insertAt(i, new Vector3(v.x, v.y, i, nv));
            ++i;
        }
        i = 2;
        while (i < this.vcount) {
            this.ptList.insertAt(i, new Vector3(0.0, 0.0, i));
            ++i;
        }
    }

    @Override
    protected void fillPointList(CoordsCanvas canvas) {
        this.setValid(true);
        int i = 0;
        while (i < 2) {
            GPoint v = (GPoint)this.parent.get(i);
            int nv = 0;
            if (!v.isValid()) {
                nv = -2;
                this.setValid(false);
            }
            this.ptList.get(i).assign(v.x, v.y, i, nv);
            ++i;
        }
        if (this.isValid()) {
            double a = Math.PI * (0.5 - 1.0 / (double)this.vcount);
            double[] dArray = new double[]{this.ptList.get((int)1).x - this.ptList.get((int)0).x, this.ptList.get((int)1).y - this.ptList.get((int)0).y};
            double[] ds = dArray;
            double bds = MyMath.hypot(ds[0], ds[1]);
            if (bds > 1.0E-12) {
                double d = Math.tan(a) / 2.0;
                if (this.isReversed()) {
                    this.polyCOG[0] = (this.ptList.get((int)0).x + this.ptList.get((int)1).x) / 2.0 + d * ds[1];
                    this.polyCOG[1] = (this.ptList.get((int)0).y + this.ptList.get((int)1).y) / 2.0 - d * ds[0];
                } else {
                    this.polyCOG[0] = (this.ptList.get((int)0).x + this.ptList.get((int)1).x) / 2.0 - d * ds[1];
                    this.polyCOG[1] = (this.ptList.get((int)0).y + this.ptList.get((int)1).y) / 2.0 + d * ds[0];
                }
                double mw = Math.PI * 2 / (double)this.vcount;
                double dw = 0.0;
                ds[0] = this.ptList.get((int)1).x - this.polyCOG[0];
                ds[1] = this.ptList.get((int)1).y - this.polyCOG[1];
                int i2 = 2;
                while (i2 < this.vcount) {
                    double[] dr = MyMath.rotateVector2(ds, dw += mw);
                    this.ptList.get((int)i2).x = this.polyCOG[0] + dr[0];
                    this.ptList.get((int)i2).y = this.polyCOG[1] + dr[1];
                    ++i2;
                }
            } else {
                this.setValid(false);
            }
        }
    }
}

