/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import applet.Options;
import canvas.CoordsCanvas;
import geoobj.GGraph;
import geoobj.GIntArea;
import geoobj.GPoint;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import terms.TermTree;

public class GRiemannArea
extends GIntArea {
    protected boolean isLowerSum = true;
    protected int intCnt = 0;
    protected TermTree nt = new TermTree("1", 0.0, this.drawing, TermTree.isRadMode);
    protected double[][] ptList;
    protected Point2D.Double[] scrPtList;

    public GRiemannArea(GeoObjList list, GGraph ibf, GPoint ip1, GPoint ip2, String sn, boolean isVisible) {
        super(list, ibf, ip1, ip2, null, isVisible);
        this.nt.buildTermTree(sn, 0.0);
        this.setValid(this.nt.isOkay());
        if (this.isValid()) {
            this.updateParams(null, 0.0, 0.0);
        }
    }

    public GRiemannArea(Element objElem, GeoObjList list) {
        super(objElem, list);
        String s;
        if (objElem.getAttributes().getNamedItem("type") != null) {
            s = objElem.getAttributes().getNamedItem("type").getNodeValue();
            this.isLowerSum = s.equalsIgnoreCase("lowersum");
        }
        if (objElem.getAttributes().getNamedItem("intervals") != null) {
            s = objElem.getAttributes().getNamedItem("intervals").getNodeValue();
            this.nt.buildTermTree(s, 0.0);
        }
    }

    @Override
    public Element createDomNode(Document domDoc) {
        Element domData = super.createDomNode(domDoc);
        if (this.isLowerSum) {
            domData.setAttribute("type", "lowersum");
        } else {
            domData.setAttribute("type", "uppersum");
        }
        domData.setAttribute("intervals", new Integer(this.getIntCnt()).toString());
        return domData;
    }

    public int getIntCnt() {
        return Math.round((float)this.nt.getValue(0.0));
    }

    @Override
    public void updateParams(GeoObj mousedObj, double lmx, double lmy) {
        int i;
        this.setValid(true);
        this.x1 = this.parent.get(0).getx(0);
        this.x2 = this.parent.get(1).getx(0);
        GGraph gf = (GGraph)this.parent.get(2);
        this.intCnt = this.getIntCnt();
        double dx = (this.x2 - this.x1) / (double)this.intCnt;
        double gran = this.myCanvas != null ? Options.ppcm : 40.0;
        this.ptList = new double[2][this.intCnt + 1];
        int i2 = 0;
        while (i2 <= this.intCnt) {
            this.ptList[0][i2] = this.x1 + dx * (double)i2;
            this.ptList[1][i2] = 0.0;
            ++i2;
        }
        boolean allright = true;
        if (this.isLowerSum) {
            i = 1;
            while (i <= this.intCnt) {
                this.ptList[1][i] = gf.getMinValIn(this.ptList[0][i - 1], this.ptList[0][i], gran);
                if (!gf.term.isOkay()) {
                    allright = false;
                }
                ++i;
            }
        } else {
            i = 1;
            while (i <= this.intCnt) {
                this.ptList[1][i] = gf.getMaxValIn(this.ptList[0][i - 1], this.ptList[0][i], gran);
                if (!gf.term.isOkay()) {
                    allright = false;
                }
                ++i;
            }
        }
        if (allright) {
            this.x = (this.x1 + this.x2) / 2.0;
            this.y = gf.term.getValue(this.x) / 2.0;
            double ysum = 0.0;
            int i3 = 1;
            while (i3 <= this.intCnt) {
                ysum += this.ptList[1][i3];
                ++i3;
            }
            this.areaVal = ysum * dx;
        } else {
            this.setValid(false);
        }
    }

    @Override
    public void draw(CoordsCanvas canvas) {
        if (this.isVisible()) {
            this.myCanvas = canvas;
            this.scrPtList = new Point2D.Double[this.intCnt + 1];
            int i = 0;
            while (i <= this.intCnt) {
                this.scrPtList[i] = new Point2D.Double();
                canvas.getScreenPtCoords(this.ptList[0][i], this.ptList[1][i], this.scrPtList[i]);
                ++i;
            }
            this.myPath.reset();
            this.myPath.moveTo((float)this.scrPtList[0].x, (float)this.scrPtList[0].y);
            i = 1;
            while (i <= this.intCnt) {
                this.myPath.lineTo((float)this.scrPtList[i - 1].x, (float)this.scrPtList[i].y);
                this.myPath.lineTo((float)this.scrPtList[i].x, (float)this.scrPtList[i].y);
                ++i;
            }
            this.myPath.lineTo((float)this.scrPtList[this.intCnt].x, (float)this.scrPtList[0].y);
            this.myPath.closePath();
            this.areaComp = new Area(this.myPath);
            canvas.fillShape(this.areaComp, this.appearance.getBrushStyle(), this.appearance.getFillColor());
            this.drawBorder(canvas);
        }
    }

    @Override
    public void drawBorder(CoordsCanvas canvas) {
        canvas.drawRiemannBorder(this.scrPtList, this.intCnt, this.appearance.getPenStyle(), this.appearance.getLineWidth(), this.appearance.getColor());
    }
}

