/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import canvas.CoordsCanvas;
import dgmath.MyMath;
import dgmath.V3List;
import geoobj.GLine;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import org.w3c.dom.Element;

public class GSegment
extends GLine {
    public GSegment(GeoObjList list) {
        super(list);
        this.ccMask = 112;
    }

    public GSegment(GeoObjList list, GeoObj ip1, GeoObj ip2, boolean iIsVisible) {
        super(list, ip1, ip2, iIsVisible);
        this.ccMask = 112;
    }

    public GSegment(Element objElem, GeoObjList list) {
        super(objElem, list);
        this.ccMask = 112;
    }

    @Override
    protected String defName() {
        return "s";
    }

    @Override
    public void draw(CoordsCanvas canvas) {
        if (this.isVisible()) {
            canvas.drawSegment(this.x1, this.y1, this.x2, this.y2, this.appearance.getPenStyle(), this.appearance.getLineWidth(), this.appearance.getColor());
        }
    }

    @Override
    public double dist(double mx, double my) {
        if (this.isValid()) {
            return MyMath.distPt2ShortLn(this.x1, this.y1, this.x2, this.y2, mx, my);
        }
        return 1.0E20;
    }

    @Override
    public double getValue(int select) {
        return MyMath.hypot(this.x2 - this.x1, this.y2 - this.y1);
    }

    @Override
    public boolean containsPoint(double px, double py) {
        return this.dist(px, py) < 1.0E-6 && (this.x2 - this.x1) * (px - this.x1) + (this.y2 - this.y1) * (py - this.y1) >= 0.0 && (this.x1 - this.x2) * (px - this.x2) + (this.y1 - this.y2) * (py - this.y2) >= 0.0;
    }

    @Override
    public double getParamFromCoords(double px, double py) {
        double[] p = new double[]{px, py, this.x1, this.y1, this.x2, this.y2};
        double[] res = MyMath.getSegmentParamFromPt(this.getEq(), p);
        if (res[2] < 0.0) {
            res[2] = 0.0;
        }
        if (res[2] > 1.0) {
            res[2] = 1.0;
        }
        return res[2];
    }

    @Override
    public double[] getCoordsFromParam(double param) {
        double[] pts = new double[]{this.x1, this.y1, this.x2, this.y2};
        double[] res = MyMath.getSegmentPtFromParam(pts, param);
        return res;
    }

    @Override
    public void resetOLCPList(CoordsCanvas canvas, V3List ptList) {
        ptList.reset2zList(23, 0.0, 1.0);
    }
}

