/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import dgmath.MyMath;
import dgmath.Vector3;
import geoobj.GLine;
import geoobj.GMapping;
import geoobj.GPoint;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import org.w3c.dom.Element;

public class GSimiliarity
extends GMapping {
    public GSimiliarity(GeoObjList list) {
        super(list);
    }

    public GSimiliarity(Element objElem, GeoObjList list) {
        super(objElem, list);
    }

    public GSimiliarity(GeoObjList list, int mType, GeoObj defO1, GeoObj defO2) {
        super(list);
        this.mapType = mType;
        this.becomesChildOf(defO1);
        this.becomesChildOf(defO2);
        this.updateParams(null, 0.0, 0.0);
    }

    @Override
    public void updateParams(GeoObj mousedObj, double lmx, double lmy) {
        this.setValid(false);
        switch (this.mapType) {
            case 1: {
                GLine axis = (GLine)this.parent.get(0);
                if (axis == null) break;
                Vector3 dir = MyMath.getDirectionFromHesseEq(axis.getEq());
                double[][] p = new double[][]{{axis.x1, axis.y1}, {axis.x1 + dir.x, axis.y1 + dir.y}, {axis.x1 - dir.y, axis.y1 + dir.x}};
                double[][] q = new double[][]{{axis.x1, axis.y1}, {axis.x1 + dir.x, axis.y1 + dir.y}, {axis.x1 + dir.y, axis.y1 - dir.x}};
                this.setValid(MyMath.getAffineMapFromPts(p, q, this.mat));
                break;
            }
            case 2: {
                GPoint centre = (GPoint)this.parent.get(0);
                if (centre == null) break;
                double[][] p = new double[][]{{centre.x, centre.y}, {centre.x + 1.0, centre.y}, {centre.x, centre.y + 1.0}};
                double[][] q = new double[][]{{centre.x, centre.y}, {centre.x - 1.0, centre.y}, {centre.x, centre.y - 1.0}};
                this.setValid(MyMath.getAffineMapFromPts(p, q, this.mat));
                break;
            }
            case 3: {
                GeoObj schieb = this.parent.get(0);
                if (schieb == null) break;
                this.mat[0][0] = 1.0;
                this.mat[1][0] = 0.0;
                this.mat[2][0] = schieb.getValue(1);
                this.mat[0][1] = 0.0;
                this.mat[1][1] = 1.0;
                this.mat[2][1] = schieb.getValue(2);
                this.setValid(true);
                break;
            }
            case 4: {
                GPoint center = (GPoint)this.parent.get(0);
                GeoObj rot = this.parent.get(1);
                if (center == null || rot == null) break;
                double a = rot.getValue(9);
                double sa = Math.sin(a);
                double ca = Math.cos(a);
                double[][] p = new double[][]{{center.x, center.y}, {center.x + 1.0, center.y}, {center.x, center.y + 1.0}};
                double[][] q = new double[][]{{center.x, center.y}, {center.x + ca, center.y + sa}, {center.x - sa, center.y + ca}};
                this.setValid(MyMath.getAffineMapFromPts(p, q, this.mat));
                break;
            }
            case 7: {
                GPoint centr = (GPoint)this.parent.get(0);
                GeoObj skal = this.parent.get(1);
                if (centr == null || skal == null) break;
                double f = skal.getValue(0);
                double[][] p = new double[][]{{centr.x, centr.y}, {centr.x + 1.0, centr.y}, {centr.x, centr.y + 1.0}};
                double[][] q = new double[][]{{centr.x, centr.y}, {centr.x + f, centr.y}, {centr.x, centr.y + f}};
                this.setValid(MyMath.getAffineMapFromPts(p, q, this.mat));
            }
        }
        this.detM = this.mat[0][0] * this.mat[1][1] - this.mat[0][1] * this.mat[1][0];
    }
}

