/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import canvas.CoordsCanvas;
import canvas.PopupMenu;
import dgmath.MyMath;
import geoobj.GNumber;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import geoobj.Messages;
import javax.swing.JMenuItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import terms.TermTree;
import xml.Helpers;

public class GTerm
extends GNumber {
    public static final int defTermObjWidth = 150;
    public static final int defTermObjHeight = 33;
    private TermTree term = null;
    private boolean showsTerm = true;
    private int showFormat = 0;
    private String commentStr = "";
    private boolean fValid = true;

    public GTerm(GeoObjList list, String termStr, double[] pos, boolean iisVisible) {
        super(list, null, pos, iisVisible);
        this.ccMask = 0x10100000;
        this.term = new TermTree(termStr, 0.0, this.drawing, TermTree.isRadMode);
        this.term.registerTermParentsIn(this);
    }

    public GTerm(Element objElem, GeoObjList list) {
        super(objElem, list);
        String sn;
        this.ccMask = 0x10100000;
        if (objElem.getAttributes().getNamedItem("show_term") != null) {
            sn = objElem.getAttributes().getNamedItem("show_term").getNodeValue();
            this.showsTerm = sn.equalsIgnoreCase("true");
        } else {
            this.showsTerm = true;
        }
        if (objElem.getAttributes().getNamedItem("show_format") != null) {
            sn = objElem.getAttributes().getNamedItem("show_format").getNodeValue();
            this.showFormat = Integer.parseInt(sn);
        } else {
            this.showFormat = 0;
        }
        Element childElem = Helpers.getChildElementByName("value", objElem);
        if (childElem != null) {
            String buf = childElem.getAttribute("term");
            this.term = new TermTree(buf, 0.0, this.drawing, TermTree.isRadMode);
            this.commentStr = childElem.getAttribute("comment");
        }
    }

    @Override
    public Element createDomNode(Document domDoc) {
        Element domData = super.createDomNode(domDoc);
        if (!this.showsName) {
            domData.setAttribute("show_name", "false");
        }
        if (!this.showsTerm) {
            domData.setAttribute("show_term", "false");
        }
        if (this.showFormat != 0) {
            domData.setAttribute("show_format", String.valueOf(this.showFormat));
        }
        Element val = domDoc.createElement("value");
        val.setAttribute("term", this.getTermStr());
        if (this.commentStr.length() > 0) {
            val.setAttribute("comment", this.commentStr);
        }
        domData.appendChild(val);
        return domData;
    }

    @Override
    protected String defName() {
        return "T";
    }

    public String getTermStr() {
        return this.term.getTermString();
    }

    public void setTermStr(String ns) {
        this.term.unregisterTermParentsIn(this);
        this.term.buildTermTree(ns, 0.0);
        this.term.registerTermParentsIn(this);
        this.updateParams(null, 0.0, 0.0);
    }

    public boolean getShowsTerm() {
        return this.showsTerm;
    }

    public void setShowsTerm(boolean nv) {
        this.showsTerm = nv;
    }

    public int getShowFormat() {
        return this.showFormat;
    }

    public void setShowFormat(int nv) {
        this.showFormat = nv;
    }

    @Override
    public int getWidth() {
        return 150;
    }

    @Override
    public int getHeight() {
        return 33;
    }

    @Override
    public boolean isVisible() {
        return this.appearance.getVisible(this.getDrawing().getVisGroupMask());
    }

    @Override
    public double dist(double mx, double my) {
        if (this.isValid() && MyMath.ptInRect(mx, my, this.x, this.y, this.x2, this.y2)) {
            return -0.1;
        }
        return 1.0E20;
    }

    @Override
    public void addToContextMenu(PopupMenu menu) {
        super.addToContextMenu(menu);
        if (this.getClass() == GTerm.class) {
            menu.add2List(new JMenuItem(Messages.getString("GTerm.menu_editterm")), 74);
        }
    }

    @Override
    public void draw(CoordsCanvas canvas) {
        if (this.isVisible()) {
            double convActVal;
            double[] pos = new double[]{this.x, this.y, this.x2, this.y2};
            String titleStr = "";
            if (this.showsName) {
                titleStr = this.name;
            }
            if (this.showsTerm) {
                if (this.showsName) {
                    titleStr = String.valueOf(titleStr) + " = ";
                }
                titleStr = String.valueOf(titleStr) + this.term.getTermString();
            }
            if (this.commentStr.length() > 0) {
                titleStr = titleStr.length() == 0 ? this.commentStr : String.valueOf(titleStr) + "  { " + this.commentStr + " }";
            }
            String valStr = "";
            switch (this.showFormat) {
                case 1: {
                    convActVal = MyMath.rad2deg(this.actVal);
                    break;
                }
                case 2: {
                    convActVal = this.actVal / Math.PI;
                    break;
                }
                default: {
                    convActVal = this.actVal;
                }
            }
            Object[] arglist = new Object[]{new Double(convActVal)};
            if (this.fValid) {
                valStr = String.format("%.5g", arglist);
                switch (this.showFormat) {
                    case 1: {
                        valStr = valStr.concat("\u00b0");
                        break;
                    }
                    case 2: {
                        valStr = valStr.concat("\u03c0");
                    }
                }
            } else {
                valStr = Messages.getString("GTerm.mess_invalid");
            }
            canvas.drawTermBox(pos, titleStr, valStr, this.appearance.getColor());
            this.x2 = pos[2];
            this.y2 = pos[3];
        }
    }

    @Override
    public void updateParams(GeoObj mousedObj, double lmx, double lmy) {
        if (this.term != null) {
            this.actVal = this.term.getValue(0.0);
            this.fValid = this.term.isOkay();
        } else {
            this.fValid = false;
        }
    }
}

