/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import applet.Options;
import canvas.CoordsCanvas;
import dgmath.MyMath;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xml.FormattedText;
import xml.Helpers;

public abstract class GTextObj
extends GeoObj {
    protected double width;
    protected double height;
    protected String htmlText;
    protected double[] p = new double[2];
    protected FormattedText formatText;

    public GTextObj(GeoObjList list) {
        super(list);
        this.ccMask = 0x1100000;
    }

    public GTextObj(Element objElem, GeoObjList list) {
        super(objElem, list);
        this.ccMask = 0x1100000;
        Element childElem = Helpers.getChildElementByName("position", objElem);
        if (childElem != null) {
            this.x = childElem.getAttribute("x").length() > 0 ? Double.parseDouble(childElem.getAttribute("x").trim()) : this.parent.get((int)0).x + 0.2;
            this.y = childElem.getAttribute("y").length() > 0 ? Double.parseDouble(childElem.getAttribute("y").trim()) : this.parent.get((int)0).y + 0.2;
            this.width = childElem.getAttribute("width").length() > 0 ? Double.parseDouble(childElem.getAttribute("width").trim()) : 6.5;
            this.height = childElem.getAttribute("height").length() > 0 ? Double.parseDouble(childElem.getAttribute("height").trim()) : 2.5;
        }
        if ((childElem = Helpers.getChildElementByName("text", objElem)) != null) {
            this.htmlText = Helpers.killAllUnixTags(childElem.getTextContent().trim());
        }
    }

    @Override
    public void afterLoading(CoordsCanvas canvas) {
        super.afterLoading(canvas);
        int w = canvas.userToScreenW(this.width);
        int h = canvas.userToScreenH(this.height);
        Point2D.Double bounds = new Point2D.Double(w, h);
        Graphics2D canvas2D = canvas.getGraphics();
        Font nf = this.drawing.getStartFont();
        nf = nf.deriveFont((float)Options.fontScale);
        this.formatText = new FormattedText(canvas2D, this.drawing.getStartFont(), this.htmlText, bounds);
        this.width = Math.abs(canvas.screenToUserW((int)bounds.getX()));
        this.height = Math.abs(canvas.screenToUserH((int)bounds.getY()));
    }

    @Override
    public Element createDomNode(Document domDoc) {
        Element domData = super.createDomNode(domDoc);
        Element pos = domDoc.createElement("position");
        pos.setAttribute("x", new Double(this.x).toString());
        pos.setAttribute("y", new Double(this.y).toString());
        pos.setAttribute("width", new Double(Math.abs(this.width)).toString());
        pos.setAttribute("height", new Double(Math.abs(this.height)).toString());
        domData.appendChild(pos);
        Element txt = domDoc.createElement("text");
        CDATASection cdata = domDoc.createCDATASection(this.htmlText);
        txt.appendChild(cdata);
        domData.appendChild(txt);
        return domData;
    }

    @Override
    public double dist(double mx, double my) {
        if (this.isValid()) {
            Rectangle2D.Double r = new Rectangle2D.Double(this.x, this.y - this.height, this.width, this.height);
            if (r.contains(mx, my)) {
                return 0.0;
            }
            return MyMath.hypot(this.x + this.width / 2.0 - mx, this.y + this.height / 2.0 - my);
        }
        return 1.0E20;
    }

    @Override
    public void draw(CoordsCanvas canvas) {
        if (this.isVisible()) {
            if (this.formatText == null) {
                Point2D.Double ul = new Point2D.Double();
                Point2D.Double br = new Point2D.Double();
                canvas.getScreenPtCoords(this.x, this.y, ul);
                canvas.getScreenPtCoords(this.x + this.width, this.y - this.height, br);
                Point2D.Double bounds = new Point2D.Double(br.x - ul.x, ul.y - br.y);
                this.formatText = new FormattedText(canvas.getGraphics(), this.drawing.getStartFont(), this.htmlText, bounds);
            }
            canvas.drawFormattedText(this.formatText, this.x, this.y, this.getColor());
        }
    }

    @Override
    public void updateParams(GeoObj mousedObj, double lmx, double lmy) {
        if (this == mousedObj) {
            this.x = lmx;
            this.y = lmy;
            this.p = this.parent.get(0).getNameParamsFromCoords(this.x, this.y);
        } else {
            double[] nc = this.parent.get(0).getNameCoordsFromParams(this.p);
            this.x = nc[0];
            this.y = nc[1];
        }
    }

    @Override
    public void moveBy(double dx, double dy, CoordsCanvas canvas) {
        super.moveBy(dx, dy, canvas);
        if (this.parent.size() > 0) {
            this.p = this.parent.get(0).getNameParamsFromCoords(this.x, this.y);
        }
    }

    public String getHtmlText() {
        return this.htmlText;
    }

    public void setHtmlText(String nv) {
        this.htmlText = nv;
        this.formatText = null;
    }
}

