/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import applet.Options;
import canvas.CoordsCanvas;
import dgmath.MyMath;
import dgmath.V3List;
import dgmath.Vector3;
import geoobj.GCurve;
import geoobj.GNumber;
import geoobj.GPoint;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import geoobj.LocLineController;
import geoobj.RelationListIterator;
import java.awt.Color;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import xml.Helpers;

public class GTrace
extends GCurve {
    public static double locSL_LineLimit = 0.999;
    public static double locSL_CircleLimit = 0.998;
    public static double locSL_ConicLimit = 0.997;
    public static int ols_isStraightLine = 65536;
    public static int ols_isCircleLine = 131072;
    public static int ols_isConicLine = 262144;
    protected CoordsCanvas myCanvas = null;
    protected int olStatus = -1;
    protected int sltyp = 0;
    protected boolean hasStandardCurveChild = false;
    protected double pixelDist = 0.035277777777777776;
    protected Vector3 lineEq = new Vector3();
    protected Vector3 circleData = new Vector3();
    protected double[] conicData = new double[6];

    public GTrace(GeoObjList list) {
        super(list);
        this.ccMask |= 0x8000;
    }

    public GTrace(GeoObjList list, GeoObj iGeneratorPt, GeoObj iDraggedObj) {
        super(list);
        this.ccMask |= 0x8000;
        this.appearance.setLineWidth(3);
        this.appearance.setColor(Color.red);
        this.becomesChildOf(iDraggedObj);
        this.becomesChildOf(iGeneratorPt);
        if (this.getClass().equals(GTrace.class)) {
            this.setIsDynamic(iDraggedObj.getClass().equals(GPoint.class) && iDraggedObj.parent.size() > 0 || iDraggedObj.getClass().equals(GNumber.class));
            this.resetParentList();
            this.olStatus = -1;
        }
    }

    public GTrace(Element objElem, GeoObjList list) {
        super(objElem, list);
        NamedNodeMap attributes = objElem.getAttributes();
        this.olStatus = attributes.getNamedItem("trace_status") != null ? Integer.parseInt(attributes.getNamedItem("trace_status").getNodeValue()) : 7;
        if (this.olStatus >= ols_isStraightLine) {
            if ((this.olStatus & ols_isConicLine) > 0) {
                this.sltyp = ols_isConicLine;
            } else if ((this.olStatus & ols_isCircleLine) > 0) {
                this.sltyp = ols_isCircleLine;
            } else if ((this.olStatus & ols_isStraightLine) > 0) {
                this.sltyp = ols_isStraightLine;
            }
        }
        if (this.parent.first() == this.parent.last()) {
            this.setIsDynamic(false);
            Element points = Helpers.getChildElementByName("points", objElem);
            String ptsStr = Helpers.killAllBreaks(points.getTextContent());
            this.ptList = new V3List(ptsStr);
        }
        this.ccMask |= 0x8000;
    }

    @Override
    public void afterLoading(CoordsCanvas canvas) {
        this.myCanvas = canvas;
        this.resetParentList();
    }

    @Override
    public Element createDomNode(Document domDoc) {
        Element domData = super.createDomNode(domDoc);
        domData.setAttribute("trace_status", new Integer(this.olStatus).toString());
        return domData;
    }

    @Override
    public boolean includes(GPoint pt) {
        return this.parent.indexOf(pt) >= 0 || pt.parent.indexOf(this) >= 0;
    }

    @Override
    public double[] getTangentDirIn(double xp, double yp) {
        double p = this.getParamFromCoords(xp, yp);
        Vector3[] pts = new Vector3[]{new Vector3(0.0, 0.0, p), new Vector3(0.0, 0.0, p)};
        double dp = 1.0E-6;
        double dp_max = 1000.0 * dp;
        double dr = 0.0;
        int i = 0;
        while (i < this.parent.size()) {
            this.parent.get(i).saveState();
            ++i;
        }
        this.saveState();
        do {
            pts[0].z -= dp;
            pts[1].z += dp;
            this.calculateOLPoint(pts[0]);
            this.calculateOLPoint(pts[1]);
        } while ((dr = MyMath.hypot(pts[1].x - pts[0].x, pts[1].y - pts[0].y)) < 1.0E-12 && (dp *= 1.618) < dp_max);
        this.restoreState();
        i = 0;
        while (i < this.parent.size()) {
            this.parent.get(i).restoreState();
            ++i;
        }
        if (dp < dp_max) {
            double[] res = new double[]{(pts[1].x - pts[0].x) / dr, (pts[1].y - pts[0].y) / dr};
            return res;
        }
        return null;
    }

    @Override
    public double[] getNormalDirIn(double xp, double yp) {
        double p = this.getParamFromCoords(xp, yp);
        Vector3[] pts = new Vector3[]{new Vector3(0.0, 0.0, p), new Vector3(0.0, 0.0, p)};
        double dp = 1.0E-6;
        double dp_max = 1000.0 * dp;
        double dr = 0.0;
        int i = 0;
        while (i < this.parent.size()) {
            this.parent.get(i).saveState();
            ++i;
        }
        this.saveState();
        do {
            pts[0].z -= dp;
            pts[1].z += dp;
            this.calculateOLPoint(pts[0]);
            this.calculateOLPoint(pts[1]);
        } while ((dr = MyMath.hypot(pts[0].y - pts[1].y, pts[1].x - pts[0].x)) < 1.0E-12 && (dp *= 1.618) < dp_max);
        this.restoreState();
        i = 0;
        while (i < this.parent.size()) {
            this.parent.get(i).restoreState();
            ++i;
        }
        if (dp < dp_max) {
            double[] res = new double[]{(pts[0].y - pts[1].y) / dr, (pts[1].x - pts[0].x) / dr};
            return res;
        }
        return null;
    }

    @Override
    public double[] getCoordsFromParam(double param) {
        double[] res = new double[]{0.0, 0.0};
        if (!this.isValid()) {
            return res;
        }
        this.setNewTempRelationships();
        int i = 0;
        while (i < this.parent.size()) {
            this.parent.get(i).saveState();
            ++i;
        }
        try {
            Vector3 v = new Vector3(0.0, 0.0, param);
            this.calculateOLPoint(v);
            if (v.getValid()) {
                res[0] = v.x;
                res[1] = v.y;
            }
        }
        catch (Exception e) {
            this.setValid(false);
        }
        i = 0;
        while (i < this.parent.size()) {
            this.parent.get(i).restoreState();
            ++i;
        }
        this.resetTempRelationships();
        return res;
    }

    @Override
    public double getParamFromCoords(double px, double py) {
        Vector3 param = new Vector3();
        Vector3[] p = new Vector3[3];
        Vector3[] q = new Vector3[2];
        int n = this.ptList.getPtIndexNextToXY(px, py);
        if (n >= 0) {
            if (n == 0 || n >= this.ptList.count()) {
                param.x = this.ptList.get((int)n).z;
            } else {
                int i = 0;
                while (i <= 2) {
                    p[i] = this.ptList.get(n - 1 + i);
                    ++i;
                }
                i = 0;
                while (i <= 1) {
                    q[i] = new Vector3(0.0, 0.0, 0.0);
                    double[] pt = new double[]{p[i].x, p[i].y};
                    Vector3 dir = new Vector3(p[i + 1].x - p[i].x, p[i + 1].y - p[i].y, 0.0);
                    Vector3 g = MyMath.getHesseEqFromPtAndDir(pt, dir);
                    pt[0] = px;
                    pt[1] = py;
                    Vector3 fp = MyMath.getPedalPoint(g, pt);
                    q[i].x = fp.x;
                    q[i].y = fp.y;
                    double[] pl = new double[]{p[i].x, p[i].y, p[i + 1].x, p[i + 1].y, fp.x, fp.y};
                    param = MyMath.getTV(pl);
                    ++i;
                }
                param.x = q[0].z >= 0.0 && q[0].z <= 1.0 ? (q[1].z >= 0.0 && q[1].z <= 1.0 ? (MyMath.hypot(q[0].x - px, q[0].y - py) < MyMath.hypot(q[1].x - px, q[1].y - py) ? p[0].z + (p[1].z - p[0].z) * q[0].z : p[1].z + (p[2].z - p[1].z) * q[1].z) : p[0].z + (p[1].z - p[0].z) * q[0].z) : (q[1].z >= 0.0 && q[1].z <= 1.0 ? p[1].z + (p[2].z - p[1].z) * q[1].z : p[0].z);
            }
        }
        if (!param.getValid()) {
            param.x = 0.0;
        }
        return param.x;
    }

    @Override
    public boolean hasSameDataAs(GeoObj o) {
        if (this.parent.first() == this.parent.last()) {
            return false;
        }
        return super.hasSameDataAs(o);
    }

    public boolean isDynamic() {
        return (this.olStatus & 1) > 0;
    }

    public void setIsDynamic(boolean newVal) {
        this.olStatus = newVal ? (this.olStatus |= 1) : (this.olStatus &= 0xFFFFFFFE);
    }

    public boolean isSpline() {
        return (this.olStatus & 2) > 0;
    }

    public void setIsSpline(boolean newVal) {
        this.olStatus = newVal ? (this.olStatus |= 2) : (this.olStatus &= 0xFFFFFFFD);
    }

    public boolean isStandardCurve() {
        return this.sltyp > 0;
    }

    public boolean hasStandardCurveDisplay() {
        return this.hasStandardCurveChild;
    }

    public Vector3 getLineEq() {
        if (this.sltyp == ols_isStraightLine) {
            Vector3 eq = new Vector3(this.lineEq);
            return eq;
        }
        return null;
    }

    public Vector3 getCircleData() {
        if (this.sltyp == ols_isCircleLine) {
            Vector3 eq = new Vector3(this.circleData);
            return eq;
        }
        return null;
    }

    public double[] getConicEq() {
        if (this.sltyp == ols_isConicLine) {
            double[] eq = (double[])this.conicData.clone();
            return eq;
        }
        return null;
    }

    @Override
    public void updateParams(GeoObj mousedObj, double lmx, double lmy) {
        if (this.olStatus < 0 && mousedObj instanceof LocLineController) {
            double lpos = ((LocLineController)((Object)mousedObj)).getLinePosition();
            int n = this.ptList.getPtIndexNextToXY(this.parent.last().x, this.parent.last().y);
            Vector3 ve = this.ptList.get(n);
            if (ve == null || MyMath.hypot(this.parent.last().x - ve.x, this.parent.last().y - ve.y) > 0.33) {
                Vector3 vn = new Vector3(this.parent.last().getx(0), this.parent.last().gety(0), lpos);
                if (this.parent.size() > 1) {
                    this.ptList.insert(vn);
                } else {
                    this.ptList.add(vn);
                }
                System.out.println("Locus line's ptList holds " + Integer.toString(this.ptList.count()) + " points.");
            }
        } else {
            GeoObj contrObj = this.parent.first();
            if (contrObj.equals(this.parent.last())) {
                this.setIsDynamic(false);
            } else {
                this.setIsDynamic(contrObj.getClass().equals(GPoint.class) && contrObj.parent.size() > 0 || contrObj.getClass().equals(GNumber.class));
            }
            if (this.isDynamic()) {
                this.fillPointList(null);
                this.check4StandardLine();
                if (this.isValid()) {
                    this.curve = null;
                }
            } else {
                this.setValid(true);
            }
        }
    }

    @Override
    public void draw(CoordsCanvas canvas) {
        block8: {
            block7: {
                if (this.olStatus >= 0) break block7;
                if (this.myCanvas == null) {
                    this.myCanvas = canvas;
                }
                if (!this.isVisible()) break block8;
                int i = 0;
                while (i < this.ptList.count()) {
                    Vector3 v = this.ptList.get(i);
                    canvas.drawPoint(v.x, v.y, 1, 2, 2, this.appearance.getColor());
                    ++i;
                }
                break block8;
            }
            if (this.isVisible()) {
                if (this.curve == null) {
                    this.curve = this.ptList.getSegmentedCurve(canvas);
                }
                if (this.curve != null) {
                    canvas.drawCurve(this.curve, this.appearance.getPenStyle(), this.appearance.getLineWidth(), this.appearance.getColor());
                } else {
                    int i = 0;
                    while (i < this.ptList.count()) {
                        Vector3 v = this.ptList.get(i);
                        canvas.drawPoint(v.x, v.y, 1, 2, 2, this.appearance.getColor());
                        ++i;
                    }
                }
            }
        }
    }

    public void stopRecording(CoordsCanvas canvas) {
        this.myCanvas = canvas;
        this.olStatus = 3;
    }

    public int check4StandardLine() {
        Vector3 pt = new Vector3();
        Vector3 dir = new Vector3();
        double[] quality = new double[1];
        double[] coeff = new double[6];
        int sltyp = 0;
        if (this.isDynamic()) {
            if (MyMath.bestLineApprox(this.ptList, quality, pt, dir) && quality[0] > locSL_LineLimit) {
                this.lineEq = MyMath.getHesseEqFromPtAndDir(pt, dir);
                sltyp = ols_isStraightLine;
            } else if (MyMath.bestCircleApprox(this.ptList, quality, pt) && quality[0] > locSL_CircleLimit) {
                this.circleData.assign(pt);
                sltyp = ols_isCircleLine;
            } else if (MyMath.bestConicApprox(this.ptList, quality, coeff) && quality[0] > locSL_ConicLimit) {
                this.conicData = coeff;
                sltyp = ols_isConicLine;
            }
            return sltyp;
        }
        return 0;
    }

    @Override
    protected String defName() {
        return "OL";
    }

    protected void resetParentList() {
        if (!this.isDynamic()) {
            return;
        }
        GeoObj draggedObj = this.parent.first();
        GeoObj generatorPt = this.parent.last();
        if (draggedObj != null && generatorPt != null) {
            if (draggedObj != generatorPt) {
                this.parent.clear();
                this.parent.add(draggedObj);
                RelationListIterator it = this.drawing.iterator();
                while (it.hasNext()) {
                    GeoObj ao = it.next();
                    if (!draggedObj.isAncestorOf(ao) || !ao.isAncestorOf(generatorPt)) continue;
                    this.parent.add(ao);
                    if (ao.getClass() != GPoint.class || ((GPoint)ao).friends.size() <= 0) continue;
                    RelationListIterator li = ((GPoint)ao).friends.iterator();
                    while (li.hasNext()) {
                        this.parent.add(li.next());
                    }
                }
                this.parent.add(generatorPt);
            } else {
                this.setIsDynamic(false);
            }
        } else {
            this.setValid(false);
        }
    }

    private void setNewTempRelationships() {
    }

    private void resetTempRelationships() {
    }

    protected void calculateOLPoint(Vector3 v) {
        GeoObj dp = this.parent.first();
        if (((LocLineController)((Object)dp)).setLinePosition(v.z)) {
            int i = 1;
            while (i < this.parent.size()) {
                try {
                    this.parent.get(i).updateParams(dp, 0.0, 0.0);
                }
                catch (Exception e) {
                    v.setValid(false);
                    return;
                }
                ++i;
            }
            if (this.parent.last().isValid()) {
                v.x = this.parent.last().x;
                v.y = this.parent.last().y;
                v.tag = this.myCanvas.containsPt(v.x, v.y) ? 1 : (this.myCanvas.knowsPt(v.x, v.y) ? 0 : -2);
            } else {
                v.setValid(false);
            }
        } else {
            v.setValid(false);
        }
    }

    private void insertPtsBetween(Vector3 v0, Vector3 v1, Vector3 v2) {
        double dist = MyMath.hypot(v1.x - v0.x, v1.y - v0.y) + MyMath.hypot(v2.x - v1.x, v2.y - v1.y);
        if (dist > this.pixelDist && Math.abs(v2.z - v0.z) > 1.0E-6 && MyMath.tooMuchBending(v0, v1, v2)) {
            Vector3 vm = new Vector3(0.0, 0.0, (v0.z + v1.z) / 2.0);
            this.calculateOLPoint(vm);
            this.ptList.insert(vm);
            Vector3 vn = new Vector3(0.0, 0.0, (v1.z + v2.z) / 2.0);
            this.calculateOLPoint(vn);
            this.ptList.insert(vn);
            if (v0.getValid() && vm.getValid() && v1.getValid()) {
                this.insertPtsBetween(v0, vm, v1);
            }
        }
    }

    private double getMinDistBetweenInflections() {
        double minDist = 1.0E10;
        boolean lastTurn = -this.ptList.get((int)0).x * this.ptList.get((int)1).y + this.ptList.get((int)0).y * this.ptList.get((int)1).x > 0.0;
        double lastTurnZ = this.ptList.get((int)0).z;
        int i = 2;
        while (i < this.ptList.count()) {
            boolean nextTurn;
            boolean bl = nextTurn = -this.ptList.get((int)(i - 1)).x * this.ptList.get((int)i).y + this.ptList.get((int)(i - 1)).y * this.ptList.get((int)i).x > 0.0;
            if (nextTurn != lastTurn) {
                double dz = this.ptList.get((int)(i - 1)).z - lastTurnZ;
                if (dz > 1.0E-6 && dz < minDist) {
                    minDist = dz;
                }
                lastTurn = nextTurn;
                lastTurnZ = this.ptList.get((int)(i - 1)).z;
            }
            ++i;
        }
        return minDist;
    }

    private void look4TheEnd(Vector3 v1, Vector3 v2) {
        if (v1 == null || v2 == null || Math.abs(v1.z - v2.z) < 1.0E-6) {
            return;
        }
        Vector3 nv = new Vector3(0.0, 0.0, (v1.z + v2.z) / 2.0);
        this.calculateOLPoint(nv);
        this.ptList.insert(nv);
        if (v1.tag == nv.tag) {
            this.look4TheEnd(nv, v2);
        } else {
            this.look4TheEnd(v1, nv);
        }
    }

    private boolean check4whiteSpaces() {
        boolean c4ws = false;
        double dz_min = this.getMinDistBetweenInflections();
        int i = 1;
        while (i < this.ptList.count()) {
            if (this.ptList.get((int)i).z - this.ptList.get((int)(i - 1)).z > dz_min) {
                double max_z = this.ptList.get((int)i).z;
                double act_z = this.ptList.get((int)(i - 1)).z + dz_min;
                while (act_z < max_z - 1.0E-6) {
                    Vector3 nv = new Vector3(0.0, 0.0, act_z);
                    this.calculateOLPoint(nv);
                    this.ptList.insert(nv);
                    act_z += dz_min;
                    c4ws = true;
                }
                i = this.ptList.getPtIndexNextToZ(max_z);
            }
            ++i;
        }
        return c4ws;
    }

    private void fillTheGaps() {
        do {
            int i = 0;
            while (i <= this.ptList.count() - 3) {
                this.insertPtsBetween(this.ptList.get(i), this.ptList.get(i + 1), this.ptList.get(i + 2));
                ++i;
            }
            i = this.ptList.count();
            this.insertPtsBetween(this.ptList.get(i - 3), this.ptList.get(i - 2), this.ptList.get(i - 1));
        } while (this.check4whiteSpaces());
    }

    /*
     * Unable to fully structure code
     */
    private void sharpenTheEnds() {
        i = 0;
        ** GOTO lbl12
        {
            ++i;
            do {
                if (i < this.ptList.count() && this.ptList.get(i) != null && this.ptList.get(i + 1) != null && this.ptList.get((int)i).tag == this.ptList.get((int)(i + 1)).tag) continue block0;
                if (i < this.ptList.count() - 2) {
                    next_z = this.ptList.get((int)(i + 1)).z;
                    this.look4TheEnd(this.ptList.get(i), this.ptList.get(i + 1));
                    i = this.ptList.getPtIndexNextToZ(next_z);
                    continue;
                }
                ++i;
lbl12:
                // 3 sources

            } while (i < this.ptList.count() - 2);
        }
    }

    private void check4jumps() {
        int i = 2;
        while (i < this.ptList.count() - 1) {
            Vector3 v0 = this.ptList.get(i - 2);
            Vector3 v1 = this.ptList.get(i - 1);
            Vector3 v2 = this.ptList.get(i);
            if (v1.tag >= 0 && v2.tag >= 0 && MyMath.tooMuchBending(v0, v1, v2)) {
                double dr = MyMath.hypot(v2.x - v1.x, v2.y - v1.y);
                double dz = Math.abs(v2.z - v1.z);
                if (1000.0 * dz < dr) {
                    this.ptList.insert(new Vector3(1.1E100, 1.1E100, (v1.z + v2.z) / 2.0, -2));
                    ++i;
                }
            }
            ++i;
        }
    }

    protected void addLines(V3List pList) {
    }

    @Override
    protected void fillPointList(CoordsCanvas canvas) {
        this.ptList.clear();
        if (canvas != null) {
            this.pixelDist = 1.0 / Options.ppcm;
        }
        LocLineController draggedObj = (LocLineController)((Object)this.parent.first());
        this.setNewTempRelationships();
        int i = 0;
        while (i < this.parent.size()) {
            this.parent.get(i).saveState();
            ++i;
        }
        try {
            draggedObj.resetOLCPList(canvas, this.ptList);
            this.addLines(this.ptList);
            i = 0;
            while (i < this.ptList.count()) {
                this.calculateOLPoint(this.ptList.get(i));
                ++i;
            }
            this.fillTheGaps();
            this.sharpenTheEnds();
            this.setValid(this.ptList.validPtCount() > 3);
            if (this.isValid()) {
                this.check4jumps();
            }
        }
        catch (Exception e) {
            this.setValid(false);
            System.err.println("Calculation error updating trace line " + this.name + " ( fillPointList() )");
        }
        i = this.parent.size() - 1;
        while (i >= 0) {
            this.parent.get(i).restoreState();
            --i;
        }
        this.resetTempRelationships();
    }
}

