/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import canvas.CoordsCanvas;
import dgmath.MyMath;
import geoobj.GPoint;
import geoobj.GSegment;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import org.w3c.dom.Element;

public class GVector
extends GSegment {
    public GVector(GeoObjList list) {
        super(list);
        this.ccMask = 176;
    }

    public GVector(GeoObjList list, GeoObj iP1, GeoObj iP2, boolean iIsVisible) {
        super(list, iP1, iP2, iIsVisible);
        this.ccMask = 176;
    }

    public GVector(Element objElem, GeoObjList list) {
        super(objElem, list);
        this.ccMask = 176;
    }

    @Override
    public double getValue(int select) {
        switch (select) {
            case 1: {
                return this.x2 - this.x1;
            }
            case 2: {
                return this.y2 - this.y1;
            }
        }
        return super.getValue(select);
    }

    public GVector getAncestorVector() {
        GeoObj pv = this.parent.get(1);
        if (pv != null && pv.isCompatibleTo(128)) {
            return ((GVector)pv).getAncestorVector();
        }
        return this;
    }

    @Override
    public void updateParams(GeoObj mousedObj, double mx, double my) {
        this.setValid(false);
        GPoint p1 = (GPoint)this.parent.get(0);
        GeoObj p2 = this.parent.get(1);
        if (p2 == null) {
            p2 = p1;
        }
        if (p1.isValid() && p2.isValid()) {
            this.x1 = p1.x;
            this.y1 = p1.y;
            if (p2 instanceof GPoint) {
                this.x2 = ((GPoint)p2).x;
                this.y2 = ((GPoint)p2).y;
            } else {
                this.x2 = this.x1 + ((GVector)p2).getValue(1);
                this.y2 = this.y1 + ((GVector)p2).getValue(2);
            }
            this.eq[0] = this.y1 - this.y2;
            this.eq[1] = this.x2 - this.x1;
            double c = MyMath.hypot(this.eq[0], this.eq[1]);
            if (Math.abs(c) > 1.0E-12) {
                this.eq[0] = this.eq[0] / c;
                this.eq[1] = this.eq[1] / c;
                this.eq[2] = this.eq[0] * this.x1 + this.eq[1] * this.y1;
                this.setValid(true);
            }
        }
    }

    @Override
    public void draw(CoordsCanvas canvas) {
        if (this.isVisible()) {
            canvas.drawVector(this.x1, this.y1, this.x2, this.y2, this.appearance.getPenStyle(), this.appearance.getLineWidth(), this.appearance.getColor());
        }
    }

    @Override
    protected String defName() {
        return "v";
    }
}

