/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import canvas.CoordsCanvas;
import canvas.PopupMenu;
import dgmath.MyMath;
import dgmath.MyStack;
import geoobj.Appearance;
import geoobj.GObjectName;
import geoobj.GeoObjList;
import geoobj.Messages;
import geoobj.RelationList;
import geoobj.RelationListIterator;
import java.awt.Color;
import javax.swing.JMenuItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xml.Helpers;

public abstract class GeoObj {
    public static final int ccNone = 0;
    public static final int ccBaseObj = 1;
    public static final int ccPointObj = 2;
    public static final int ccBoundPoint = 4;
    public static final int ccLineObj = 16;
    public static final int ccStraightLine = 32;
    public static final int ccSegment = 64;
    public static final int ccVector = 128;
    public static final int ccRay = 256;
    public static final int ccLongLine = 512;
    public static final int ccArc = 2048;
    public static final int ccCircle = 4096;
    public static final int ccConic = 8192;
    public static final int ccGraph = 16384;
    public static final int ccLocusLine = 32768;
    public static final int ccClosedLine = 65536;
    public static final int ccPolygon = 131072;
    public static final int ccAngle = 262144;
    public static final int ccAreaObj = 0x100000;
    public static final int ccPicture = 0x200000;
    public static final int ccTextObj = 0x1000000;
    public static final int ccName = 0x2000000;
    public static final int ccMeasure = 0x4000000;
    public static final int ccNumberObj = 0x10000000;
    public static final int ccMapping = 0x20000000;
    public static final int ccAnyObj = -1;
    public static final int gvVal = 0;
    public static final int gvX = 1;
    public static final int gvY = 2;
    public static final int gvLen = 3;
    public static final int gvRadius = 4;
    public static final int gvArea = 5;
    public static final int gvMin = 6;
    public static final int gvMax = 7;
    public static final int gvQuant = 8;
    public static final int gvAngle = 9;
    protected double x = 0.0;
    protected double y = 0.0;
    private boolean fIsMarked = false;
    private boolean fIsValid = true;
    protected RelationList child = new RelationList();
    protected RelationList parent = new RelationList();
    protected int id;
    protected String name;
    protected GeoObjList drawing;
    protected int ccMask;
    protected Appearance appearance = new Appearance();
    protected MyStack stack = new MyStack();

    public GeoObj(GeoObjList list) {
        this.drawing = list;
        this.id = list.getFreeId();
        this.name = list.getFreeName(this.defName());
    }

    public GeoObj(Element objElem, GeoObjList list) {
        this.drawing = list;
        this.id = Integer.parseInt(objElem.getAttribute("id"));
        this.name = objElem.getAttribute("name");
        this.appearance.setVisible(true);
        Element childElem = Helpers.getChildElementByName("appearance", objElem);
        if (childElem != null) {
            int gn;
            if (childElem.getAttribute("visible").length() > 0) {
                this.appearance.setVisible(Boolean.parseBoolean(childElem.getAttribute("visible")));
            }
            if (childElem.getAttribute("pen_style").length() > 0) {
                this.appearance.setPenStyle(Integer.parseInt(childElem.getAttribute("pen_style")));
            }
            if (childElem.getAttribute("line_width").length() > 0) {
                this.appearance.setLineWidth(Integer.parseInt(childElem.getAttribute("line_width")));
            }
            if (childElem.getAttribute("shape").length() > 0) {
                this.appearance.setShape(Integer.parseInt(childElem.getAttribute("shape")));
            }
            if (childElem.getAttribute("brush_style").length() > 0) {
                this.appearance.setBrushStyle(Integer.parseInt(childElem.getAttribute("brush_style")));
            }
            if (childElem.getAttribute("color").length() > 0) {
                this.appearance.setColor(childElem.getAttribute("color"));
            }
            if (childElem.getAttribute("add_data2name").length() > 0) {
                this.appearance.setAddData2Name(Boolean.parseBoolean(childElem.getAttribute("add_data2name")));
            }
            if (childElem.getAttribute("groups").length() > 0 && (gn = Integer.parseInt(childElem.getAttribute("groups"))) >= 0 && gn <= Integer.MAX_VALUE) {
                this.appearance.setGroups(gn);
            }
        }
        if ((childElem = Helpers.getChildElementByName("parents", objElem)) != null) {
            String parentInfo = childElem.getTextContent().trim();
            String[] pos = parentInfo.split(";");
            int i = 0;
            while (i < pos.length) {
                this.becomesChildOf(list.getObjectById(Integer.parseInt(pos[i].trim())));
                ++i;
            }
        }
    }

    public abstract void draw(CoordsCanvas var1);

    public abstract void updateParams(GeoObj var1, double var2, double var4);

    public abstract double dist(double var1, double var3);

    public Element createDomNode(Document domDoc) {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.deleteCharAt(0);
        Element domData = domDoc.createElement(sb.toString());
        domData.setAttribute("id", new Integer(this.id).toString());
        domData.setAttribute("name", this.getName());
        Element appear = domDoc.createElement("appearance");
        boolean saveIt = false;
        if (!this.getColor().equals(Color.BLACK)) {
            appear.setAttribute("color", this.appearance.getColorString());
            saveIt = true;
        }
        if (this.appearance.getPenStyle() > 0) {
            appear.setAttribute("pen_style", new Integer(this.appearance.getPenStyle()).toString());
            saveIt = true;
        }
        if (this.appearance.getLineWidth() != 1) {
            appear.setAttribute("line_width", new Integer(this.appearance.getLineWidth()).toString());
            saveIt = true;
        }
        if (this.appearance.getShape() != 1) {
            appear.setAttribute("shape", new Integer(this.appearance.getShape()).toString());
            saveIt = true;
        }
        if (this.appearance.getBrushStyle() != 1) {
            appear.setAttribute("brush_style", new Integer(this.appearance.getBrushStyle()).toString());
            saveIt = true;
        }
        if (this.appearance.getAddData2Name()) {
            appear.setAttribute("add_data2name", "true");
            saveIt = true;
        }
        if (this.appearance.getGroups() > 0) {
            appear.setAttribute("groups", new Integer(this.appearance.getGroups()).toString());
            saveIt = true;
        } else if (!this.isVisible()) {
            appear.setAttribute("visible", "false");
            saveIt = true;
        }
        if (saveIt) {
            domData.appendChild(appear);
        }
        if (this.parent.size() > 0) {
            Element pali = domDoc.createElement("parents");
            pali.setTextContent(this.parent.getIdStr());
            domData.appendChild(pali);
        }
        return domData;
    }

    public void addToContextMenu(PopupMenu menu) {
        menu.add2List(new JMenuItem(Messages.getString("GeoObj.menu_hide")), 112);
        menu.add2List(new JMenuItem(Messages.getString("GeoObj.menu_editname")), 113);
        menu.add2List(null, 0);
        menu.add2List(new JMenuItem(Messages.getString("GeoObj.menu_editcol")), 61);
    }

    public double[] getNameParamsFromCoords(double nx, double ny) {
        double[] res = new double[]{nx - this.x, ny - this.y};
        return res;
    }

    public double[] getNameCoordsFromParams(double[] np) {
        double[] res = new double[]{this.x + np[0], this.y + np[1]};
        return res;
    }

    public double[] getDefaultNameParams() {
        double[] res = new double[]{0.1, 0.2};
        return res;
    }

    public boolean hasSameDataAs(GeoObj o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        return o.getClass().equals(this.getClass());
    }

    public double getx(int sel) {
        return this.x;
    }

    public double gety(int sel) {
        return this.y;
    }

    public double getValue(int select) {
        return 0.0;
    }

    public int getParentCount() {
        return this.parent.size();
    }

    public void breakRelations() {
        while (!this.child.isEmpty()) {
            this.child.get(0).breakRelations();
        }
        while (!this.parent.isEmpty()) {
            this.stopsToBeChildOf(this.parent.get(0));
        }
    }

    public void becomesChildOf(GeoObj iParent) {
        if (iParent != null) {
            this.parent.add(iParent);
            iParent.child.add(this);
        }
    }

    public void stopsToBeChildOf(GeoObj iParent) {
        this.parent.remove(iParent);
        iParent.child.remove(this);
    }

    public final int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int setName(String nn) {
        if (nn.length() > 0) {
            int n = MyMath.isValidName(nn);
            if (n < 0) {
                RelationListIterator iter = this.drawing.iterator();
                while (iter.hasNext()) {
                    GeoObj o = iter.next();
                    if (o == this || !o.getName().equals(nn)) continue;
                    return -1;
                }
                this.name = nn;
                GObjectName no = this.getNameObj();
                if (no != null) {
                    no.setText(nn);
                }
                return 0;
            }
            return n + 1;
        }
        return -2;
    }

    public final Color getColor() {
        return this.appearance.getColor();
    }

    public final void setColor(Color newCol) {
        this.appearance.setColor(newCol);
        GObjectName no = this.getNameObj();
        if (no != null) {
            no.appearance.setColor(newCol);
        }
    }

    public final int getShape() {
        return this.appearance.getShape();
    }

    public final void setVisible(boolean val) {
        this.appearance.setVisible(val);
    }

    public void setMark(boolean m) {
        if (this.fIsMarked != m) {
            this.fIsMarked = m;
        }
    }

    public void setMarks(boolean m) {
        if (this.fIsMarked != m) {
            this.fIsMarked = m;
            int i = 0;
            while (i < this.child.size()) {
                this.child.get(i).setMarks(m);
                ++i;
            }
        }
    }

    public boolean isMarked() {
        return this.fIsMarked;
    }

    public boolean allParentsUnmarked() {
        int i = 0;
        while (i < this.parent.size()) {
            if (this.parent.get(i).isMarked()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isAncestorOf(GeoObj go) {
        boolean iao = this.child.indexOf(go) >= 0;
        RelationListIterator it = this.child.iterator();
        while (!iao && it.hasNext()) {
            iao = it.next().isAncestorOf(go);
        }
        return iao;
    }

    public boolean isValid() {
        return this.fIsValid;
    }

    public void setBlinking(boolean bl) {
        this.appearance.setBlinking(bl);
    }

    public boolean isVisible() {
        return this.appearance.getVisible(this.drawing.getVisGroupMask()) && this.fIsValid;
    }

    public boolean isCompatibleTo(int ccCode) {
        return (ccCode & this.ccMask) != 0;
    }

    public boolean canMoveFree() {
        return false;
    }

    public GeoObj getParent(int num) {
        if (num >= 0 && num < this.parent.size()) {
            return this.parent.get(num);
        }
        return null;
    }

    public GeoObj getChild(int num) {
        if (num >= 0 && num < this.child.size()) {
            return this.child.get(num);
        }
        return null;
    }

    public int getChildrenCount() {
        return this.child.size();
    }

    public void resize(CoordsCanvas canvas) {
    }

    public void moveBy(double dx, double dy, CoordsCanvas canvas) {
        this.x += dx;
        this.y += dy;
    }

    public boolean hasSameParentsAs(GeoObj go, boolean ordered) {
        return this.parent.hasSameDataAs(go.parent, ordered);
    }

    public boolean hasNameObj() {
        return this.getNameObj() != null;
    }

    public GObjectName getNameObj() {
        GObjectName res = null;
        RelationListIterator it = this.child.iterator();
        while (it.hasNext()) {
            GeoObj next = it.next();
            if (!next.getClass().equals(GObjectName.class)) continue;
            res = (GObjectName)next;
        }
        return res;
    }

    public GeoObjList getDrawing() {
        return this.drawing;
    }

    public void afterLoading(CoordsCanvas canvas) {
    }

    public void register4Dragging(RelationList dragList) {
        dragList.add(this);
    }

    public void saveState() {
        this.stack.pushDouble(this.x);
        this.stack.pushDouble(this.y);
        this.stack.pushBool(this.fIsValid);
    }

    public void restoreState() {
        this.fIsValid = this.stack.popBool();
        this.y = this.stack.popDouble();
        this.x = this.stack.popDouble();
    }

    protected void setValid(boolean val) {
        this.fIsValid = val;
    }

    protected String defName() {
        return "_";
    }
}

