/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import canvas.CoordsCanvas;
import canvas.PopupMenu;
import geoobj.GMapping;
import geoobj.GStick;
import geoobj.GeoObj;
import geoobj.Messages;
import geoobj.RelationList;
import geoobj.RelationListIterator;
import geoobj.VisGroupList;
import java.awt.Font;
import java.util.HashMap;
import javax.swing.JMenuItem;
import org.w3c.dom.Element;

public class GeoObjList
extends RelationList {
    public boolean isLoading = false;
    private RelationList dragList = new RelationList();
    private VisGroupList groups = new VisGroupList();
    private HashMap<Integer, GeoObj> idMap = new HashMap();
    private HashMap<String, GeoObj> nameMap = new HashMap();
    private HashMap<Integer, Integer> aliasMap = new HashMap();
    private Font startFont = new Font("SansSerif", 0, 16);
    private int nextAvailableId = 1;
    private boolean isBlinking = false;
    private boolean isBlinkOn = true;
    private String strBuf = "";
    private GeoObj aniSource = null;

    public GeoObj insertGO(GeoObj go) {
        GeoObj ngo = this.existsSameObjAs(go);
        if (ngo == null) {
            super.add(go);
            if (go.getId() >= this.nextAvailableId) {
                this.nextAvailableId = go.getId() + 1;
            }
            this.idMap.put(new Integer(go.getId()), go);
            this.nameMap.put(new String(go.getName()), go);
            return go;
        }
        go.breakRelations();
        this.aliasMap.put(new Integer(go.getId()), new Integer(ngo.getId()));
        System.out.println("Such an objects exists already. We'll take the existing old one (" + ngo.name + "; id:" + ngo.id + ") and discard the new (" + go.name + "; id:" + go.id + ").");
        return ngo;
    }

    public void deleteGO(GeoObj go) {
        if (this.indexOf(go) >= 0) {
            while (go.child.size() > 0) {
                this.deleteGO(go.child.get(0));
            }
            this.idMap.remove(new Integer(go.getId()));
            this.nameMap.remove(new String(go.getName()));
            go.breakRelations();
            this.remove(go);
        }
    }

    public void deleteGO(int n) {
        if (n < this.size()) {
            GeoObj go = this.get(n);
            while (go.child.size() > 0) {
                this.deleteGO(go.child.get(0));
            }
            go.breakRelations();
            this.idMap.remove(new Integer(go.getId()));
            this.nameMap.remove(go.getName());
            this.remove(go);
        }
    }

    @Override
    public void clear() {
        this.dragList.clear();
        int i = this.size() - 1;
        while (i >= 0) {
            this.deleteGO(i);
            --i;
        }
    }

    public GeoObj getObjectById(int id) {
        Integer aid;
        GeoObj res = this.idMap.get(new Integer(id));
        if (res == null && (aid = this.aliasMap.get(new Integer(id))) != null) {
            res = this.idMap.get(aid);
        }
        return res;
    }

    public GeoObj getObjectByName(String on) {
        return this.nameMap.get(on);
    }

    public int getFreeId() {
        return this.nextAvailableId++;
    }

    public String getFreeName(String dn) {
        int n = 1;
        while (this.nameMap.containsKey(String.valueOf(dn) + n)) {
            ++n;
        }
        return String.valueOf(dn) + n;
    }

    public void setAniSource(int id) {
        GeoObj go = this.getObjectById(id);
        if (go != null) {
            this.aniSource = go;
        }
    }

    public GeoObj getAniSource() {
        if (this.aniSource != null && this.indexOf(this.aniSource) > 0) {
            return this.aniSource;
        }
        return null;
    }

    public VisGroupList getVisGroups() {
        return this.groups;
    }

    public void loadVisGroups(Element groupListNode) {
        this.groups.loadGroupsFromXML(this, groupListNode);
    }

    public int getVisGroupMask() {
        return this.groups.getVisMask();
    }

    public void drawAllObjs(CoordsCanvas coordsCanvas) {
        if (this.size() < 5) {
            return;
        }
        int i = 5;
        while (i < this.size()) {
            if ((this.get((int)i).ccMask & 0x100000) > 0) {
                this.get(i).draw(coordsCanvas);
            }
            ++i;
        }
        i = 5;
        while (i < this.size()) {
            if ((this.get((int)i).ccMask & 0x40000) > 0) {
                this.get(i).draw(coordsCanvas);
            }
            ++i;
        }
        i = 5;
        while (i < this.size()) {
            if ((this.get((int)i).ccMask & 0x200000) > 0 || (this.get((int)i).ccMask & 0x10000000) > 0 || (this.get((int)i).ccMask & 0x1000000) > 0) {
                this.get(i).draw(coordsCanvas);
            }
            ++i;
        }
        i = 0;
        while (i < 5) {
            this.get(i).draw(coordsCanvas);
            ++i;
        }
        i = 5;
        while (i < this.size()) {
            if ((this.get((int)i).ccMask & 0x10) > 0) {
                this.get(i).draw(coordsCanvas);
            }
            ++i;
        }
        i = 5;
        while (i < this.size()) {
            if ((this.get((int)i).ccMask & 2) > 0) {
                this.get(i).draw(coordsCanvas);
            }
            ++i;
        }
    }

    public GeoObj getMousedObj(int expType, double mx, double my, double dr) {
        GeoObj obj = null;
        double dist = dr;
        RelationListIterator iter = this.iterator();
        while (iter.hasNext()) {
            GeoObj o = iter.next();
            if (!o.isCompatibleTo(expType) || !o.isVisible() || !(Math.abs(o.dist(mx, my)) <= dist) || obj != null && o.ccMask > obj.ccMask) continue;
            obj = o;
        }
        return obj;
    }

    public GeoObj getContextObj(double mx, double my, double dr) {
        GeoObj obj = null;
        double dist = dr;
        RelationListIterator iter = this.iterator();
        while (iter.hasNext()) {
            double odist;
            GeoObj o = iter.next();
            if (!o.isVisible() || !((odist = o.dist(mx, my)) <= dist) || obj != null && o.ccMask > obj.ccMask) continue;
            obj = o;
        }
        return obj;
    }

    public GeoObj getMovableObj(double mx, double my) {
        GeoObj obj = null;
        double dist = 0.0;
        RelationListIterator iter = this.iterator();
        while (iter.hasNext()) {
            double odist;
            GeoObj o = iter.next();
            if (!o.isVisible() || (o.ccMask & 0x100000) <= 0 || !((odist = o.dist(mx, my)) <= dist) || obj != null && o.ccMask > obj.ccMask) continue;
            obj = o;
            dist = odist;
        }
        return obj;
    }

    public GMapping getTransformationWith(int mType, GeoObj def1, GeoObj def2) {
        GMapping res = null;
        int i = this.size() - 1;
        while (i >= 5) {
            if (this.get(i) instanceof GMapping) {
                GMapping am = (GMapping)this.get(i);
                if (am.mapType == mType && (am.parent.get(0) == def1 && def2 == null || am.parent.get(0) == def1 && am.parent.get(1) == def2)) {
                    res = am;
                }
            }
            --i;
        }
        return res;
    }

    public void fillDragList(GeoObj startObj) {
        if (this.dragList.isEmpty() || !this.dragList.get(0).equals(startObj)) {
            this.clearDragList();
            if (startObj != null) {
                startObj.setMarks(true);
                this.fdl(startObj);
            }
        }
    }

    public void updateDraggedObjs(GeoObj mousedObj, double x, double y) {
        int i = 0;
        while (i < this.dragList.size()) {
            this.dragList.get(i).updateParams(mousedObj, x, y);
            ++i;
        }
        this.groups.updateVisMask();
    }

    public void updateAllChildrenOf(GeoObj selObj, double mx, double my) {
        selObj.setMarks(true);
        selObj.setMark(false);
        int i = this.indexOf(selObj);
        while (i < this.size()) {
            GeoObj go = this.get(i);
            if (go.isMarked()) {
                go.updateParams(null, mx, my);
            }
            ++i;
        }
        this.revokeAllMarks();
    }

    public void removeTempParentships() {
        int i = 0;
        while (i < this.size()) {
            if (this.get(i) instanceof GStick) {
                GeoObj P0 = this.get((int)i).parent.get(0);
                GeoObj P1 = this.get((int)i).parent.get(1);
                P0.stopsToBeChildOf(P1);
                P1.stopsToBeChildOf(P0);
            }
            ++i;
        }
    }

    public void updateAllObjs() {
        int i = 0;
        while (i < this.size()) {
            this.get(i).updateParams(null, 0.0, 0.0);
            ++i;
        }
        this.groups.updateVisMask();
    }

    public void clearDragList() {
        this.removeTempParentships();
        this.dragList.clear();
    }

    public void startBlinking() {
        this.isBlinking = true;
        this.isBlinkOn = false;
    }

    public void toggleBlinking() {
        this.isBlinkOn = this.isBlinking ? !this.isBlinkOn : true;
        RelationListIterator it = this.iterator();
        while (it.hasNext()) {
            it.next().appearance.setBlinkOn(this.isBlinkOn);
        }
    }

    public boolean getBlinkOn() {
        return this.isBlinkOn;
    }

    public void stopBlinking() {
        this.isBlinking = false;
        this.isBlinkOn = true;
        RelationListIterator it = this.iterator();
        while (it.hasNext()) {
            it.next().setBlinking(false);
        }
    }

    public void resize(CoordsCanvas canvas) {
        RelationListIterator it = this.iterator();
        while (it.hasNext()) {
            it.next().resize(canvas);
        }
    }

    public void revokeAllMarks() {
        RelationListIterator it = this.iterator();
        while (it.hasNext()) {
            it.next().setMark(false);
        }
    }

    public void makeAllObjsVisible() {
        RelationListIterator it = this.iterator();
        while (it.hasNext()) {
            it.next().setVisible(true);
        }
    }

    public void addToContextMenu(PopupMenu menu) {
        menu.add2List(new JMenuItem(Messages.getString("GeoObjList.menu_new")), 512);
        menu.add2List(new JMenuItem(Messages.getString("GeoObjList.menu_saveas")), 104);
        menu.add2List(null, 0);
        menu.add2List(new JMenuItem(Messages.getString("GeoObjList.menu_delobj")), 114);
        menu.add2List(new JMenuItem(Messages.getString("GeoObjList.menu_showall")), 118);
        menu.add2List(null, 0);
        menu.add2List(new JMenuItem(Messages.getString("GeoObjList.menu_enlarge")), 115);
        menu.add2List(new JMenuItem(Messages.getString("GeoObjList.menu_reduce")), 116);
        menu.add2List(new JMenuItem(Messages.getString("GeoObjList.menu_refresh")), 513);
        menu.add2List(null, 0);
        menu.add2List(new JMenuItem(Messages.getString("GeoObjList.menu_about")), 514);
    }

    public void afterLoading(CoordsCanvas canvas) {
        canvas.installSafeGraphic();
        RelationListIterator it = this.iterator();
        while (it.hasNext()) {
            it.next().afterLoading(canvas);
        }
        it = this.iterator();
        while (it.hasNext()) {
            it.next().updateParams(null, 0.0, 0.0);
        }
        canvas.revokeSafeGraphic();
        this.groups.updateVisMask();
    }

    public void setStrBuf(String ns) {
        this.strBuf = ns;
    }

    public String getStrBuf() {
        return this.strBuf;
    }

    public void setStartFont(Font startFont) {
        this.startFont = startFont;
    }

    public Font getStartFont() {
        return this.startFont;
    }

    private void processTempParentship(GStick st) {
        int index0 = this.dragList.indexOf(st.parent.get(0));
        int index1 = this.dragList.indexOf(st.parent.get(1));
        if (index0 >= 0 && index1 < 0) {
            st.parent.get(1).becomesChildOf(st.parent.get(0));
            st.parent.get(1).setMarks(true);
        } else if (index1 >= 0 && index0 < 0) {
            st.parent.get(0).becomesChildOf(st.parent.get(1));
            st.parent.get(0).setMarks(true);
        }
    }

    private void fdl(GeoObj obj) {
        if (obj.isMarked() && obj.allParentsUnmarked()) {
            this.dragList.add(obj);
            obj.setMark(false);
            int i = 0;
            while (i < obj.child.size()) {
                if (obj.child.get(i) instanceof GStick) {
                    this.processTempParentship((GStick)obj.child.get(i));
                }
                this.fdl(obj.child.get(i));
                ++i;
            }
        }
    }

    protected GeoObj existsSameObjAs(GeoObj go) {
        if (!this.isLoading) {
            RelationListIterator rit = this.iterator();
            while (rit.hasNext()) {
                GeoObj ngo = rit.next();
                if (!go.hasSameDataAs(ngo)) continue;
                return ngo;
            }
        }
        return null;
    }
}

