/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import geoobj.GeoObj;
import geoobj.RelationListIterator;
import java.util.ArrayList;

public class RelationList {
    private ArrayList<GeoObj> list = new ArrayList();

    public void add(GeoObj go) {
        if (this.list.indexOf(go) < 0) {
            this.list.add(go);
        }
    }

    public void insert(int n, GeoObj go) {
        if (this.list.indexOf(go) < 0) {
            this.list.add(n, go);
        }
    }

    public boolean remove(GeoObj go) {
        if (this.list.remove(go)) {
            while (this.list.remove(go)) {
            }
            return true;
        }
        return false;
    }

    public GeoObj get(int index) {
        if (index >= 0 && index < this.size()) {
            return this.list.get(index);
        }
        return null;
    }

    public GeoObj first() {
        return this.list.get(0);
    }

    public GeoObj last() {
        int n = this.list.size() - 1;
        return this.list.get(n);
    }

    public int indexOf(GeoObj go) {
        return this.list.indexOf(go);
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public void clear() {
        if (!this.list.isEmpty()) {
            this.list.clear();
        }
    }

    public RelationListIterator iterator() {
        return new RelationListIterator(this.list.iterator());
    }

    public boolean hasSameDataAs(RelationList rl, boolean ordered) {
        if (this.size() != rl.size()) {
            return false;
        }
        if (ordered) {
            int n = 0;
            while (n < this.size()) {
                if (rl.indexOf(this.get(n)) != n) {
                    return false;
                }
                ++n;
            }
        } else {
            RelationListIterator i = this.iterator();
            while (i.hasNext()) {
                if (rl.indexOf(i.next()) >= 0) continue;
                return false;
            }
        }
        return true;
    }

    public String getIdStr() {
        StringBuilder res = new StringBuilder("");
        RelationListIterator it = this.iterator();
        while (it.hasNext()) {
            if (res.length() > 0) {
                res.append(";");
            }
            res.append(it.next().id);
        }
        return res.toString();
    }

    public void sortByDependencies() {
        int i = 0;
        while (i < this.size()) {
            GeoObj go = this.get(i);
            int k = 0;
            while (k < go.getParentCount()) {
                int n = this.indexOf(go.getParent(k));
                if (n > i) {
                    this.list.remove(i);
                    this.list.add(n, go);
                    go = this.get(i);
                    k = 0;
                    continue;
                }
                ++k;
            }
            ++i;
        }
    }
}

