/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import geoobj.GeoObjList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import terms.BoolTermTree;

public class VisGroup {
    protected int id = 0;
    protected String comment = "";
    protected GeoObjList drawing = null;
    protected boolean isStatic = true;
    protected boolean statVisible = true;
    protected String condition = "";
    protected BoolTermTree condTree = null;
    protected int mask = 0;

    public VisGroup(int iId, String iComment, String iCondition, GeoObjList iDrawing) {
        this.id = iId;
        this.mask = 1 << this.id;
        this.comment = iComment;
        this.isStatic = false;
        this.drawing = iDrawing;
        this.condition = iCondition;
        this.condTree = new BoolTermTree(this.condition, this.drawing, true);
    }

    public VisGroup(int iId, String iComment, boolean iVisible, GeoObjList iDrawing) {
        this.id = iId;
        this.mask = 1 << this.id;
        this.comment = iComment;
        this.isStatic = true;
        this.drawing = iDrawing;
        this.statVisible = iVisible;
    }

    public Element createDomNode(Document domDoc) {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.deleteCharAt(0);
        Element domData = domDoc.createElement("group");
        domData.setAttribute("id", new Integer(this.id).toString());
        domData.setAttribute("comment", this.comment);
        if (this.isStatic) {
            domData.setAttribute("visible", new Boolean(this.statVisible).toString());
        } else {
            domData.setAttribute("condition", this.condition);
        }
        return domData;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isVisible() {
        if (this.isStatic) {
            return this.statVisible;
        }
        return this.condTree.getValue(1.0);
    }

    public void setVisible(boolean nv) {
        if (this.isStatic) {
            this.statVisible = nv;
        }
    }

    public int getMask() {
        return this.mask;
    }

    public String getComment() {
        return this.comment;
    }
}

