/*
 * Decompiled with CFR 0.152.
 */
package geoobj;

import geoobj.GeoObjList;
import geoobj.VisGroup;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import xml.Helpers;

public class VisGroupList {
    private ArrayList<VisGroup> list = new ArrayList();
    private GeoObjList drawing = null;
    private int fVisMask = 0;

    public void loadGroupsFromXML(GeoObjList iDrawing, Element domGroups) {
        this.drawing = iDrawing;
        this.clear();
        NodeList listOfGroups = domGroups.getElementsByTagName("group");
        int i = 0;
        while (i < listOfGroups.getLength()) {
            VisGroup newGroup;
            boolean newIsStatic;
            Element groupElem = (Element)listOfGroups.item(i);
            int newId = Integer.parseInt(groupElem.getAttribute("id"));
            String newComment = groupElem.getAttribute("comment");
            boolean bl = newIsStatic = !groupElem.hasAttribute("condition");
            if (newIsStatic) {
                boolean newIsVisible = groupElem.getAttribute("visible").equalsIgnoreCase("true");
                newGroup = new VisGroup(newId, newComment, newIsVisible, this.drawing);
            } else {
                String newCondition = Helpers.rebuildDelimiters(groupElem.getAttribute("condition"));
                newGroup = new VisGroup(newId, newComment, newCondition, this.drawing);
            }
            this.add(newGroup);
            ++i;
        }
        this.updateVisMask();
    }

    public void updateVisMask() {
        this.fVisMask = 0;
        int i = 0;
        while (i < this.list.size()) {
            if (this.get(i).isVisible()) {
                this.fVisMask |= this.get(i).getMask();
            }
            ++i;
        }
    }

    public Element createDomNode(Document domDoc) {
        Element domData = null;
        if (this.list.size() > 0) {
            domData = domDoc.createElement("grouplist");
            int i = 0;
            while (i < this.list.size()) {
                domData.appendChild(this.get(i).createDomNode(domDoc));
                ++i;
            }
        }
        return domData;
    }

    public int getVisMask() {
        return this.fVisMask;
    }

    private void add(VisGroup vg) {
        this.list.add(vg);
    }

    public VisGroup get(int index) {
        if (index >= 0 && index < this.list.size()) {
            return this.list.get(index);
        }
        return null;
    }

    public VisGroup getVGbyName(String name) {
        for (VisGroup vg : this.list) {
            if (!vg.getComment().equals(name)) continue;
            return vg;
        }
        return null;
    }

    public int getCount() {
        return this.list.size();
    }

    public int getStaticCount() {
        int n = 0;
        int i = 0;
        while (i < this.list.size()) {
            if (this.get(i).isStatic()) {
                ++n;
            }
            ++i;
        }
        return n;
    }

    private void clear() {
        if (!this.list.isEmpty()) {
            this.list.clear();
        }
    }
}

