/*
 * Decompiled with CFR 0.152.
 */
package terms;

import geoobj.GLine;
import geoobj.GPoint;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import terms.Knoten;
import terms.Messages;
import terms.TermTree;

public class BoolTermTree {
    protected GeoObjList drawing = null;
    protected boolean fRad = true;
    protected boolean fOkay = true;
    protected String fSourceStr = null;
    protected String fErrorMsg = null;
    protected Knoten fBaum = null;
    protected int nci = -1;
    protected double x_val = 0.0;
    private static String[] op_name = new String[]{"=", "<", "<=", ">", ">=", "<>", "or", "xor", "and", "not"};
    private static String[] c_name = new String[]{"true", "false"};
    private static String brackets = "()[]{}";
    private static String[] f_name = new String[]{"", "parall", "ortho", "incid", "valid"};
    private String bbmsg01 = Messages.getString("BoolTermTree.mess_01");
    private String bbmsg02 = Messages.getString("BoolTermTree.mess_02");
    private String bbmsg03 = Messages.getString("BoolTermTree.mess_03");
    private String bbmsg04 = Messages.getString("BoolTermTree.mess_04");
    private String bbmsg05 = Messages.getString("BoolTermTree.mess_05");

    public BoolTermTree(String s, GeoObjList list, boolean isRad) {
        this.drawing = list;
        if (s != null && s.length() > 0) {
            this.fSourceStr = s;
            this.buildTreeAndReturn(s);
        }
        this.fRad = isRad;
    }

    public BoolTermTree createCopy() {
        BoolTermTree res = new BoolTermTree(null, this.drawing, this.fRad);
        res.fSourceStr = new String(this.fSourceStr);
        res.fBaum = Knoten.copyKnot(this.fBaum);
        res.fOkay = this.getOkay();
        return res;
    }

    public boolean buildTreeAndReturn(String s) {
        boolean res = false;
        if (this.fBaum != null) {
            this.fBaum = null;
        }
        if (s.length() > 0) {
            s = s.trim();
        }
        this.nci = 0;
        this.fErrorMsg = "";
        this.fOkay = true;
        this.fBaum = this.boolExpr(s);
        if (this.fBaum != null) {
            int n = s.length();
            if (this.nci < n) {
                StringBuilder sb = new StringBuilder(s);
                sb.delete(sb.length() - n, n);
                this.fSourceStr = sb.toString();
            } else {
                res = true;
            }
            this.fOkay = true;
        }
        return res;
    }

    public boolean getValue(double x) {
        boolean res = false;
        if (this.fBaum == null) {
            String s = this.fSourceStr;
            this.buildTreeAndReturn(s);
        }
        if (this.fBaum != null) {
            this.fOkay = true;
            this.x_val = x;
            res = this.bbval(this.fBaum);
        }
        return res;
    }

    public String getSourceStr() {
        return this.fSourceStr;
    }

    public boolean getOkay() {
        return this.fOkay;
    }

    public void registerTermParentsIn(GeoObj owner) {
        this.regTP(this.fBaum, owner);
    }

    public void unregisterTermParentsIn(GeoObj owner) {
        this.unregTP(this.fBaum, owner);
    }

    protected boolean bbval(Knoten k) {
        this.fOkay = true;
        switch (k.token) {
            case 101: {
                return this.bbval(k.getLeftCh()) == this.bbval(k.getRightCh());
            }
            case 106: {
                return this.bbval(k.getLeftCh()) ^ this.bbval(k.getRightCh());
            }
            case 107: {
                return this.bbval(k.getLeftCh()) || this.bbval(k.getRightCh());
            }
            case 108: {
                return this.bbval(k.getLeftCh()) ^ this.bbval(k.getRightCh());
            }
            case 109: {
                return this.bbval(k.getLeftCh()) && this.bbval(k.getRightCh());
            }
            case 110: {
                return !this.bbval(k.getLeftCh());
            }
            case 111: {
                return true;
            }
            case 112: {
                return false;
            }
            case 113: {
                return this.bbval(k.getLeftCh());
            }
            case 141: {
                return this.isParallel(k);
            }
            case 142: {
                return this.isOrthogonal(k);
            }
            case 143: {
                return this.isIncident(k);
            }
            case 144: {
                return this.isValid(k);
            }
            case 200: {
                TermTree lt = (TermTree)k.leftCh;
                TermTree rt = (TermTree)k.rightCh;
                double ls = lt.getValue(this.x_val);
                double rs = rt.getValue(this.x_val);
                if (lt.isOkay() && rt.isOkay()) {
                    int n = (int)k.value;
                    switch (n) {
                        case 101: {
                            return Math.abs(ls - rs) < 1.0E-12;
                        }
                        case 102: {
                            return ls < rs;
                        }
                        case 103: {
                            return ls < rs || Math.abs(ls - rs) < 1.0E-12;
                        }
                        case 104: {
                            return ls > rs;
                        }
                        case 105: {
                            return ls > rs || Math.abs(ls - rs) < 1.0E-12;
                        }
                        case 106: {
                            return Math.abs(ls - rs) > 1.0E-12;
                        }
                    }
                    this.fOkay = false;
                    return false;
                }
                this.fOkay = false;
                return false;
            }
        }
        this.fOkay = false;
        return false;
    }

    protected char getNextChar(String s) {
        while (this.nci < s.length() && s.charAt(this.nci) == ' ') {
            ++this.nci;
        }
        if (this.nci < s.length()) {
            return s.charAt(this.nci);
        }
        return '\u0000';
    }

    protected Knoten boolExpr(String s) {
        this.nci = 0;
        Knoten kn1 = this.orTerm(s);
        if (kn1 != null && this.nci < s.length() - 2) {
            this.getNextChar(s);
            String t = s.substring(this.nci).toLowerCase();
            if (t.startsWith(op_name[6])) {
                this.nci += 2;
                this.getNextChar(s);
                int old_nci = this.nci;
                Knoten kn2 = this.boolExpr(s.substring(this.nci));
                if (kn2 != null) {
                    kn1 = new Knoten(107, 0.0, kn1, kn2);
                } else {
                    kn1 = null;
                    this.fErrorMsg = this.bbmsg04;
                }
                this.nci += old_nci;
            } else if (t.startsWith(op_name[7])) {
                this.nci += 3;
                this.getNextChar(s);
                int old_nci = this.nci;
                Knoten kn2 = this.boolExpr(s.substring(this.nci));
                if (kn2 != null) {
                    kn1 = new Knoten(107, 0.0, kn1, kn2);
                } else {
                    kn1 = null;
                    this.fErrorMsg = this.bbmsg04;
                }
                this.nci += old_nci;
            } else {
                kn1 = null;
                this.fErrorMsg = this.bbmsg01;
            }
        }
        return kn1;
    }

    protected Knoten orTerm(String s) {
        Knoten kn1 = this.andTerm(s);
        if (kn1 != null && s.length() >= this.nci + 3) {
            this.getNextChar(s);
            String t = s.substring(this.nci).toLowerCase();
            if (t.startsWith(op_name[8])) {
                this.nci += 3;
                Knoten kn2 = this.orTerm(s);
                if (kn2 != null) {
                    kn1 = new Knoten(109, 0.0, kn1, kn2);
                } else {
                    kn1 = null;
                    this.fErrorMsg = this.bbmsg04;
                }
            }
        }
        return kn1;
    }

    protected Knoten andTerm(String s) {
        Knoten kn1;
        boolean f_not = false;
        if (s.length() >= 3) {
            this.getNextChar(s);
            String t = s.substring(this.nci).toLowerCase();
            if (t.startsWith(op_name[9])) {
                f_not = true;
                this.nci += 3;
            }
        }
        if ((kn1 = this.boolConst(s)) == null) {
            kn1 = this.boolFunc(s);
        }
        if (kn1 != null) {
            if (f_not) {
                kn1 = new Knoten(110, 0.0, kn1, null);
            }
        } else {
            this.fErrorMsg = this.bbmsg02;
        }
        return kn1;
    }

    protected Knoten boolConst(String s) {
        Knoten k1 = null;
        this.getNextChar(s);
        String t = s.toLowerCase();
        if (t.startsWith(c_name[0])) {
            this.nci += 4;
            k1 = new Knoten(111, 0.0, null, null);
        } else if (t.startsWith(c_name[1])) {
            this.nci += 5;
            k1 = new Knoten(112, 0.0, null, null);
        }
        return k1;
    }

    protected int getBoolFuncIndex(String s) {
        int res = 0;
        String ws = s.toLowerCase();
        int i = 1;
        while (i <= 4) {
            if (ws.startsWith(f_name[i])) {
                res = i;
                this.nci += f_name[i].length();
            }
            ++i;
        }
        return res;
    }

    protected boolean readGeoObjIdsFrom(String s, int[] pList) {
        String data;
        char nc;
        boolean res = false;
        while (brackets.indexOf(nc = this.getNextChar(s)) == -1 && this.nci < s.length()) {
        }
        int mbi = this.getMatchingClosingBracket(this.nci, s);
        if (mbi > this.nci && (data = s.substring(this.nci + 1, mbi)).length() > 0) {
            String[] dl = data.split(";");
            res = true;
            int i = 0;
            while (i < dl.length) {
                dl[i] = dl[i].trim();
                GeoObj GO = this.drawing.getObjectByName(dl[i]);
                if (GO != null) {
                    pList[i] = GO.getId();
                } else {
                    pList[i] = -1;
                    res = false;
                }
                ++i;
            }
        }
        return res;
    }

    protected Knoten boolFunc(String s) {
        Knoten kn = null;
        int old_nci = this.nci;
        int bfi = this.getBoolFuncIndex(s);
        if (bfi > 0) {
            switch (bfi) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    int[] pList = new int[4];
                    if (this.readGeoObjIdsFrom(s, pList)) {
                        kn = new Knoten(140 + bfi, null, pList);
                        break;
                    }
                    this.nci = old_nci;
                    this.fErrorMsg = this.bbmsg05;
                    break;
                }
                default: {
                    this.nci = old_nci;
                    this.fErrorMsg = this.bbmsg04;
                    break;
                }
            }
        } else {
            char c = this.getNextChar(s);
            int bli = brackets.indexOf(c);
            if (bli >= 0 && bli % 2 == 0) {
                int obi = this.nci;
                int cbi = this.getMatchingClosingBracket(obi, s);
                if (cbi < s.length() && cbi > obi) {
                    kn = this.boolExpr(s.substring(obi + 1, cbi));
                    if (kn != null) {
                        kn = new Knoten(113, obi, kn, null);
                        this.nci = cbi + 1;
                        this.getNextChar(s);
                    } else {
                        this.fErrorMsg = this.bbmsg04;
                        this.nci = old_nci;
                    }
                } else {
                    this.fErrorMsg = String.valueOf(brackets.charAt(obi + 1)) + this.bbmsg03;
                    this.nci = old_nci;
                }
            } else {
                kn = this.compRTerm(s);
                if (kn == null) {
                    this.fErrorMsg = this.bbmsg04;
                    this.nci = old_nci;
                }
            }
        }
        return kn;
    }

    protected int getMatchingClosingBracket(int obi, String s) {
        int res = -1;
        int bli = brackets.indexOf(s.charAt(obi));
        if (bli >= 0) {
            int bc = 1;
            int i = obi + 1;
            do {
                char c;
                int bic;
                if ((bic = brackets.indexOf(c = s.charAt(i))) == bli) {
                    ++bc;
                    continue;
                }
                if (bic != bli + 1) continue;
                --bc;
            } while (bc > 0 && ++i < s.length());
            if (bc == 0 && i <= s.length()) {
                res = i - 1;
            }
        }
        return res;
    }

    protected Knoten compRTerm(String s) {
        Knoten kn1 = null;
        String[] ws = this.getWorkStrings(s);
        if (ws != null) {
            TermTree ls = new TermTree(ws[0], 0.0, this.drawing, TermTree.isRadMode);
            int token = this.getToken(ws[1]);
            int[] loc_nci = new int[]{ws[2].length()};
            TermTree rs = new TermTree(ws[2], this.drawing, TermTree.isRadMode, loc_nci);
            this.nci += loc_nci[0];
            kn1 = new Knoten(200, ls, rs, token);
        }
        return kn1;
    }

    protected String[] getWorkStrings(String s) {
        char c;
        String ops = "=<>";
        String[] res = new String[3];
        do {
            c = this.getNextChar(s);
            ++this.nci;
        } while (this.nci < s.length() && ops.indexOf(c) < 0);
        --this.nci;
        res[0] = s.substring(0, this.nci).trim();
        int i = this.nci;
        do {
            c = this.getNextChar(s);
            ++this.nci;
        } while (this.nci < s.length() && ops.indexOf(c) >= 0);
        --this.nci;
        res[1] = s.substring(i, this.nci).trim();
        res[2] = s.substring(this.nci).trim();
        return res;
    }

    protected int getToken(String ts) {
        int i = 0;
        while (i < 6 && !ts.equalsIgnoreCase(op_name[i])) {
            ++i;
        }
        if (i < 6) {
            return 101 + i;
        }
        return 0;
    }

    private void regTP(Knoten knot, GeoObj owner) {
        if (knot != null) {
            switch (knot.token) {
                case 141: 
                case 142: 
                case 143: 
                case 144: {
                    break;
                }
                case 200: {
                    ((TermTree)knot.leftCh).registerTermParentsIn(owner);
                    ((TermTree)knot.rightCh).registerTermParentsIn(owner);
                    break;
                }
                default: {
                    this.regTP(knot.getLeftCh(), owner);
                    this.regTP(knot.getRightCh(), owner);
                }
            }
        }
    }

    private void unregTP(Knoten knot, GeoObj owner) {
        if (knot != null) {
            switch (knot.token) {
                case 141: 
                case 142: 
                case 143: 
                case 144: {
                    break;
                }
                case 200: {
                    ((TermTree)knot.leftCh).unregisterTermParentsIn(owner);
                    ((TermTree)knot.rightCh).unregisterTermParentsIn(owner);
                    break;
                }
                default: {
                    this.unregTP(knot.getLeftCh(), owner);
                    this.unregTP(knot.getRightCh(), owner);
                }
            }
        }
    }

    private boolean getGeoObjsFrom(Knoten k, GeoObj[] GOs) {
        if (k.has4int()) {
            int[] data = k.read4int();
            int n = 0;
            while (n < 4) {
                GOs[n] = null;
                ++n;
            }
            int i = 0;
            while (i < 4 && data[i] > 0) {
                GOs[i] = this.drawing.getObjectById(data[i]);
                ++i;
            }
            return i > 0;
        }
        return false;
    }

    private boolean isValid(Knoten k) {
        GeoObj[] GOs = new GeoObj[4];
        if (this.getGeoObjsFrom(k, GOs)) {
            return GOs[0].isValid();
        }
        return false;
    }

    private boolean isIncident(Knoten k) {
        GeoObj[] GOs = new GeoObj[4];
        if (this.getGeoObjsFrom(k, GOs) && GOs[0] instanceof GPoint && GOs[1] instanceof GLine) {
            double d = ((GLine)GOs[1]).dist(GOs[0].getx(0), GOs[0].gety(0));
            return d < 1.0E-6;
        }
        return false;
    }

    private boolean isOrthogonal(Knoten k) {
        GeoObj[] GOs = new GeoObj[4];
        if (this.getGeoObjsFrom(k, GOs)) {
            if (GOs[0] instanceof GLine) {
                if (GOs[1] instanceof GLine) {
                    return ((GLine)GOs[0]).isOrthogonal((GLine)GOs[1]);
                }
                return ((GLine)GOs[0]).isOrthogonal((GPoint)GOs[1], (GPoint)GOs[2]);
            }
            if (GOs[2] instanceof GLine) {
                return ((GLine)GOs[2]).isOrthogonal((GPoint)GOs[0], (GPoint)GOs[1]);
            }
            return this.isOrthogonalPointPairs((GPoint)GOs[0], (GPoint)GOs[1], (GPoint)GOs[2], (GPoint)GOs[3]);
        }
        return false;
    }

    private boolean isParallel(Knoten k) {
        return false;
    }

    private boolean isOrthogonalPointPairs(GPoint p1, GPoint p2, GPoint p3, GPoint p4) {
        double d;
        double dyb;
        double dxb;
        double ddb;
        double dya;
        double dxa = p2.getValue(1) - p1.getValue(1);
        double dda = Math.hypot(dxa, dya = p2.getValue(2) - p1.getValue(2));
        if (dda > 1.0E-12) {
            dxa /= dda;
            dya /= dda;
        }
        if ((ddb = Math.hypot(dxb = p4.getValue(1) - p3.getValue(1), dyb = p4.getValue(2) - p3.getValue(2))) > 1.0E-12) {
            dxb /= ddb;
            dyb /= ddb;
        }
        return Math.abs(d = dxa * dxb + dya * dyb) < 1.0E-6;
    }
}

