/*
 * Decompiled with CFR 0.152.
 */
package terms;

import terms.BoolTermTree;
import terms.TermTree;

public class Knoten {
    public int token;
    public double value;
    public Object leftCh;
    public Object rightCh;

    public Knoten(int iToken, double iValue, Knoten iLeftCh, Knoten iRightCh) {
        this.token = iToken;
        this.value = iValue;
        this.leftCh = iLeftCh;
        this.rightCh = iRightCh;
    }

    public Knoten(int iToken, Object ls, Object rs) {
        this.token = iToken;
        this.value = 0.0;
        this.leftCh = ls;
        this.rightCh = rs;
    }

    public Knoten(int iToken, TermTree ls, TermTree rs, int iValue) {
        this.token = iToken;
        this.value = iValue;
        this.leftCh = ls;
        this.rightCh = rs;
    }

    public static Knoten copyKnot(Knoten source) {
        if (source == null) {
            return null;
        }
        Knoten res = null;
        if (source.token == 30) {
            BoolTermTree cloneBTT = ((BoolTermTree)source.leftCh).createCopy();
            TermTree rlc = TermTree.createCopyOf((TermTree)source.getRightCh().leftCh);
            TermTree rrc = TermTree.createCopyOf((TermTree)source.getRightCh().rightCh);
            res = new Knoten(source.token, cloneBTT, new Knoten(source.getRightCh().token, rlc, rrc));
        } else if (source.token == 200) {
            TermTree lc = TermTree.createCopyOf((TermTree)source.leftCh);
            TermTree rc = TermTree.createCopyOf((TermTree)source.rightCh);
            int v = (int)Math.rint(source.value);
            res = new Knoten(source.token, lc, rc, v);
        } else {
            Knoten lc = Knoten.copyKnot(source.getLeftCh());
            Knoten rc = Knoten.copyKnot(source.getRightCh());
            res = new Knoten(source.token, source.value, lc, rc);
        }
        return res;
    }

    public Knoten getLeftCh() {
        return (Knoten)this.leftCh;
    }

    public Knoten getRightCh() {
        return (Knoten)this.rightCh;
    }

    public boolean hasSameDataAs(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (this.token != ((Knoten)o).token) {
            return false;
        }
        if (this.token == 0 && this.value != ((Knoten)o).value) {
            return false;
        }
        if (this.leftCh == null ? ((Knoten)o).leftCh != null : !((Knoten)this.leftCh).hasSameDataAs(((Knoten)o).leftCh)) {
            return false;
        }
        return !(this.rightCh == null ? ((Knoten)o).rightCh != null : !((Knoten)this.rightCh).hasSameDataAs(((Knoten)o).rightCh));
    }

    public boolean has4int() {
        return this.rightCh instanceof int[];
    }

    public int[] read4int() {
        if (this.has4int()) {
            return (int[])this.rightCh;
        }
        return null;
    }

    public void write4int(int[] data) {
        int[] kdata = new int[4];
        int i = 0;
        while (i < 4) {
            if (i < data.length) {
                kdata[i] = data[i];
            }
            ++i;
        }
        this.rightCh = kdata;
    }

    public void switchChildren() {
        Object buf = this.leftCh;
        this.leftCh = this.rightCh;
        this.rightCh = buf;
    }
}

