/*
 * Decompiled with CFR 0.152.
 */
package terms;

import dgmath.MyMath;
import geoobj.GAngle;
import geoobj.GMeasureDistance;
import geoobj.GNumber;
import geoobj.GSegment;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import terms.BoolTermTree;
import terms.Knoten;
import xml.Helpers;

public class TermTree {
    public static boolean isRadMode = true;
    public static boolean isDegMode = false;
    private static final String digit = "0123456789";
    private String termStr;
    private int nci;
    private Knoten baum;
    private Knoten diffBaum = null;
    private boolean fRad = false;
    private boolean okay;
    private double x_const = 0.0;
    private GeoObjList drawing = null;
    private double val;
    private int fDiffStat = 0;
    private static String[] fname = new String[]{"sqr", "sqrt", "log", "ln", "exp", "sin", "cos", "tan", "arctan", "abs", "sgn", "rnd", "arcsin", "arccos", "grad", "bogen", "int", "frac", "floor", "ceil", "random", "if"};
    private static String[] efname = new String[]{"d", "w", "x", "y", "len", "radius", "area", "val", "tv", "slope"};
    private static String brackets = "()[]{}";

    public TermTree(String s, double x, GeoObjList list, boolean isRad) {
        this.drawing = list;
        this.fRad = isRad;
        s = Helpers.rebuildDelimiters(s);
        this.buildTermTree(s, x);
        if (this.okay) {
            this.diffBaum = this.derive(this.baum);
            if (this.fDiffStat != 2) {
                this.diffBaum = null;
            }
        }
    }

    public TermTree(String s, GeoObjList list, boolean isRad, int[] res_nci) {
        this.drawing = list;
        this.fRad = isRad;
        if (s != null && s.length() > 0) {
            this.x_const = 1.0;
            this.termStr = s;
            this.nci = 0;
            this.baum = this.sum();
            this.okay = this.baum != null;
            res_nci[0] = this.nci < this.termStr.length() ? this.nci : this.termStr.length();
            if (this.okay) {
                this.diffBaum = this.derive(this.baum);
                if (this.fDiffStat != 2) {
                    this.diffBaum = null;
                }
            }
        } else {
            this.okay = false;
        }
    }

    public static TermTree createCopyOf(TermTree ori) {
        TermTree res = new TermTree(null, 0.0, ori.drawing, ori.getRad());
        res.termStr = new String(ori.termStr);
        res.baum = Knoten.copyKnot(ori.baum);
        res.diffBaum = Knoten.copyKnot(ori.diffBaum);
        res.okay = ori.isOkay();
        return res;
    }

    public TermTree createDerivativeOf(TermTree ori) {
        TermTree res = new TermTree(null, 0.0, ori.drawing, ori.getRad());
        res.baum = this.derive(ori.baum);
        return res;
    }

    public void buildTermTree(String s, double x) {
        if (s != null && s.length() > 0) {
            this.x_const = x;
            this.termStr = s;
            this.nci = 0;
            this.baum = this.sum();
            boolean bl = this.okay = this.baum != null && this.nci >= this.termStr.length();
            if (this.okay) {
                this.diffBaum = this.derive(this.baum);
                if (this.fDiffStat != 2) {
                    this.diffBaum = null;
                }
            }
        } else {
            this.okay = false;
        }
    }

    public boolean hasSameDataAs(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        if (this.baum == null) {
            return ((TermTree)o).baum == null;
        }
        return this.baum.hasSameDataAs(((TermTree)o).baum);
    }

    public boolean hasDiffTerm() {
        return this.fDiffStat == 2;
    }

    public boolean isOkay() {
        return this.okay;
    }

    public boolean getRad() {
        return this.fRad;
    }

    public void setRad(boolean newIsRad) {
        this.fRad = newIsRad;
    }

    public double getValue(double x) {
        boolean bl = this.okay = this.baum != null;
        if (this.okay) {
            this.x_const = x;
            return this.calcVal(this.baum);
        }
        return 0.0;
    }

    public double getDiffValue(double x) {
        boolean bl = this.okay = this.diffBaum != null;
        if (this.okay) {
            this.x_const = x;
            return this.calcVal(this.diffBaum);
        }
        return 0.0;
    }

    public String getTermString() {
        if (this.baum != null && this.termStr.length() > 0) {
            return this.termStr;
        }
        return "";
    }

    public double integrate(double aa, double bb) {
        double[] tol = new double[50];
        double[] a = new double[50];
        double[] h = new double[50];
        double[] s = new double[50];
        double[] fa = new double[50];
        double[] fb = new double[50];
        double[] fc = new double[50];
        double[] v = new double[8];
        int[] alev = new int[50];
        double res = 0.0;
        int max_level = 40;
        boolean ok = true;
        double fd = 0.0;
        double fe = 0.0;
        int i = 1;
        tol[i] = 1.0E-5;
        a[i] = aa;
        h[i] = 0.5 * (bb - aa);
        if (!this.isOkay()) {
            return 0.0;
        }
        fa[i] = this.getValue(aa);
        if (!this.isOkay()) {
            return 0.0;
        }
        fc[i] = this.getValue(aa + h[i]);
        if (!this.isOkay()) {
            return 0.0;
        }
        fb[i] = this.getValue(bb);
        s[i] = h[i] * (fa[i] + 4.0 * fc[i] + fb[i]) / 3.0;
        alev[i] = 1;
        while (i > 0 && ok) {
            if (!this.isOkay()) {
                return 0.0;
            }
            fd = this.getValue(a[i] + 0.5 * h[i]);
            if (!this.isOkay()) {
                return 0.0;
            }
            fe = this.getValue(a[i] + 1.5 * h[i]);
            double s1 = h[i] * (fa[i] + 4.0 * fd + fc[i]) / 6.0;
            double s2 = h[i] * (fc[i] + 4.0 * fe + fb[i]) / 6.0;
            v[1] = a[i];
            v[2] = fa[i];
            v[3] = fc[i];
            v[4] = fb[i];
            v[5] = h[i];
            v[6] = tol[i];
            v[7] = s[i];
            int level = alev[i];
            --i;
            if (Math.abs(s1 + s2 - v[7]) < v[6] && level > 3) {
                res += s1 + s2;
                continue;
            }
            if (level >= max_level) {
                ok = false;
                continue;
            }
            a[++i] = v[1] + v[5];
            fa[i] = v[3];
            fc[i] = fe;
            fb[i] = v[4];
            h[i] = 0.5 * v[5];
            tol[i] = 0.5 * v[6];
            s[i] = s2;
            alev[i] = level + 1;
            a[++i] = v[1];
            fa[i] = v[2];
            fc[i] = fd;
            fb[i] = v[3];
            h[i] = h[i - 1];
            tol[i] = tol[i - 1];
            s[i] = s1;
            alev[i] = alev[i - 1];
        }
        if (!ok) {
            this.okay = false;
            res = 0.0;
        }
        return res;
    }

    public void registerTermParentsIn(GeoObj owner) {
        this.regTP(this.baum, owner);
    }

    public void unregisterTermParentsIn(GeoObj owner) {
        this.unregTP(this.baum, owner);
    }

    /*
     * Exception decompiling
     */
    private double calcVal(Object o_knot) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private char getNextChar() {
        while (this.nci < this.termStr.length() && this.termStr.charAt(this.nci) == ' ') {
            ++this.nci;
        }
        if (this.nci < this.termStr.length()) {
            return this.termStr.charAt(this.nci);
        }
        return '\u0000';
    }

    private boolean natnum() {
        double v = 0.0;
        boolean res = false;
        char c = this.getNextChar();
        int n = digit.indexOf(c);
        while (n >= 0) {
            v = 10.0 * v + (double)n;
            ++this.nci;
            c = this.getNextChar();
            n = digit.indexOf(c);
            res = true;
        }
        this.val = v;
        return res;
    }

    private Knoten number() {
        double v = 0.0;
        boolean isMinus = false;
        int c = this.getNextChar();
        if (c == 45 || c == 43) {
            ++this.nci;
            boolean bl = isMinus = c == 45;
        }
        if (this.natnum()) {
            v = this.val;
            c = this.getNextChar();
            if (c == 46 || c == 44) {
                ++this.nci;
                c = this.getNextChar();
                int n = digit.indexOf(c);
                if (n >= 0) {
                    double d = 0.1;
                    while (n >= 0) {
                        ++this.nci;
                        v += d * (double)n;
                        d /= 10.0;
                        c = this.getNextChar();
                        n = digit.indexOf(c);
                    }
                } else {
                    return null;
                }
            }
            if (c == 69 || c == 101) {
                ++this.nci;
                c = this.getNextChar();
                if (c == 43 || c == 45) {
                    ++this.nci;
                } else {
                    c = 43;
                }
                if (this.natnum()) {
                    double e = Math.pow(10.0, this.val);
                    v = c == 45 ? (v /= e) : (v *= e);
                } else {
                    return null;
                }
            }
            if (isMinus) {
                v = -v;
            }
            return new Knoten(0, v, null, null);
        }
        return null;
    }

    private Knoten bracketterm() {
        char c = this.getNextChar();
        if (c == '(') {
            ++this.nci;
            Knoten k = this.sum();
            if (k != null && (c = this.getNextChar()) == ')') {
                ++this.nci;
                return k;
            }
        }
        return null;
    }

    private int getMatchingClosingBracket(int obi, String s) {
        int res = -1;
        int bli = brackets.indexOf(s.charAt(obi));
        if (bli >= 0) {
            int bc = 1;
            int i = obi + 1;
            do {
                char c;
                int bic;
                if ((bic = brackets.indexOf(c = s.charAt(i))) == bli) {
                    ++bc;
                    continue;
                }
                if (bic != bli + 1) continue;
                --bc;
            } while (bc > 0 && ++i < s.length());
            if (bc == 0 && i <= s.length()) {
                res = i - 1;
            }
        }
        return res;
    }

    private int getFirstFuncIndex(String[] funcList) {
        int res = -1;
        String func = "";
        int old_nci = this.nci;
        char c = this.getNextChar();
        while (Character.isLetter(c)) {
            ++this.nci;
            func = String.valueOf(func) + Character.toLowerCase(c);
            c = this.getNextChar();
        }
        int i = 0;
        while (res < 0 && i < funcList.length) {
            if (func.equals(funcList[i]) && this.termStr.length() > this.nci && this.termStr.charAt(this.nci) == '(') {
                res = i;
                continue;
            }
            ++i;
        }
        if (res < 0) {
            this.nci = old_nci;
        }
        return res;
    }

    private GeoObj[] getArgObjsFrom(String st) {
        String[] names = st.split(";");
        GeoObj[] objs = new GeoObj[names.length];
        int i = 0;
        while (i < names.length) {
            objs[i] = this.drawing.getObjectByName(names[i]);
            if (objs[i] == null) {
                return null;
            }
            ++i;
        }
        return objs;
    }

    private Knoten buildEuklidFuncNode(int fn) {
        Knoten res = null;
        String argname = "";
        switch (fn) {
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                argname = "";
                ++this.nci;
                char c = this.getNextChar();
                if (!Character.isLetterOrDigit(c) && c != '_') break;
                ++this.nci;
                argname = String.valueOf(argname) + c;
                c = this.getNextChar();
                while (Character.isLetterOrDigit(c) || c == '_' || c == ';' || c == ' ') {
                    ++this.nci;
                    if (c != ' ') {
                        argname = String.valueOf(argname) + c;
                    }
                    c = this.getNextChar();
                }
                if (c != ')') break;
                ++this.nci;
                GeoObj mo = null;
                GeoObj[] objs = this.getArgObjsFrom(argname);
                if (objs == null) break;
                switch (fn) {
                    case 40: {
                        if (objs.length == 2) {
                            mo = this.drawing.insertGO(new GMeasureDistance(this.drawing, objs[0], objs[1], false));
                            break;
                        }
                        if (objs.length != 1) break;
                        mo = objs[0];
                        break;
                    }
                    case 41: {
                        if (objs.length == 3) {
                            mo = this.drawing.insertGO(new GAngle(this.drawing, objs[0], objs[1], objs[2], false, false));
                            break;
                        }
                        if (objs.length != 1) break;
                        mo = objs[0];
                        break;
                    }
                    case 48: {
                        if (objs.length == 3) {
                            res = new Knoten(fn, objs[0].getId(), new Knoten(0, objs[1].getId(), new Knoten(0, objs[2].getId(), null, null), null), null);
                        }
                        return res;
                    }
                    default: {
                        if (objs.length != 1) break;
                        mo = objs[0];
                    }
                }
                if (mo == null) break;
                res = new Knoten(fn, mo.getId(), null, null);
                break;
            }
            default: {
                ++this.nci;
                char c = this.getNextChar();
                if (!Character.isLetter(c)) break;
                ++this.nci;
                argname = String.valueOf(argname) + c;
                c = this.getNextChar();
                while (Character.isLetterOrDigit(c)) {
                    ++this.nci;
                    if (c != ' ') {
                        argname = String.valueOf(argname) + c;
                    }
                    c = this.getNextChar();
                }
                if (c != ')') break;
                ++this.nci;
                GeoObj mo = this.drawing.getObjectByName(argname);
                if (mo == null) break;
                res = new Knoten(fn, mo.getId(), null, null);
            }
        }
        return res;
    }

    private GeoObj readEuklidObj() {
        GeoObj res = null;
        int old_nci = this.nci++;
        char c = this.getNextChar();
        String name = "";
        if (Character.isLetter(c)) {
            name = String.valueOf(name) + c;
            c = this.getNextChar();
            while (Character.isLetterOrDigit(c) || Character.isJavaIdentifierStart(c)) {
                ++this.nci;
                name = String.valueOf(name) + c;
                c = this.getNextChar();
            }
            if (name.length() > 0 && MyMath.isValidName(name) < 0 && (res = this.drawing.getObjectByName(name)) != null && !(res instanceof GNumber) && !(res instanceof GSegment)) {
                res = null;
            }
        }
        if (res == null) {
            this.nci = old_nci;
        }
        return res;
    }

    private String[] myUnbracketedSplit(String s, char d) {
        int lbl = 0;
        int fdi = 0;
        int[] di = new int[25];
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '(') {
                ++lbl;
            } else if (s.charAt(i) == ')') {
                --lbl;
            }
            if (s.charAt(i) == d && lbl == 0) {
                di[fdi] = i;
                ++fdi;
            }
            ++i;
        }
        String[] res = new String[fdi + 1];
        res[0] = s.substring(0, di[0]);
        int i2 = 1;
        while (i2 < fdi) {
            res[i2] = s.substring(di[i2 - 1] + 1, di[i2]);
            ++i2;
        }
        res[fdi] = s.substring(di[fdi - 1] + 1, s.length());
        return res;
    }

    private Knoten function() {
        Knoten res = null;
        int n = this.getFirstFuncIndex(fname);
        if (n >= 0) {
            if (n == 21) {
                int cbi = this.getMatchingClosingBracket(this.nci, this.termStr);
                String bs = this.termStr.substring(this.nci + 1, cbi);
                String[] args = this.myUnbracketedSplit(bs, ';');
                if (args.length >= 2) {
                    BoolTermTree cond = new BoolTermTree(args[0], this.drawing, this.fRad);
                    TermTree t1 = new TermTree(args[1], 0.0, this.drawing, this.fRad);
                    TermTree t2 = null;
                    if (args.length > 2) {
                        t2 = new TermTree(args[2], 0.0, this.drawing, this.fRad);
                    }
                    if (cond.getOkay() && t1.isOkay() && (t2 == null || t2.isOkay())) {
                        Knoten k1 = new Knoten(0, t1, t2, 0);
                        res = new Knoten(30, cond, k1);
                        this.nci = cbi + 1;
                    }
                }
            } else {
                Knoten k1 = this.bracketterm();
                if (k1 != null) {
                    res = new Knoten(9 + n, 0.0, k1, null);
                }
            }
        } else {
            n = this.getFirstFuncIndex(efname);
            if (n >= 0) {
                res = this.buildEuklidFuncNode(40 + n);
            } else {
                GeoObj go = this.readEuklidObj();
                if (go != null) {
                    res = new Knoten(47, go.getId(), null, null);
                }
            }
        }
        return res;
    }

    private Knoten varConst() {
        char c = this.getNextChar();
        if (c == 'x' || c == 'X') {
            ++this.nci;
            return new Knoten(1, 0.0, null, null);
        }
        if (c == 'e' || c == 'E') {
            ++this.nci;
            return new Knoten(0, Math.E, null, null);
        }
        if (c == 'p' || c == 'P') {
            ++this.nci;
            c = this.getNextChar();
            if (c == 'i' || c == 'I') {
                ++this.nci;
                return new Knoten(0, Math.PI, null, null);
            }
        }
        return null;
    }

    private Knoten potenz() {
        Knoten k1 = this.number();
        if (k1 == null) {
            k1 = this.bracketterm();
        }
        if (k1 == null) {
            k1 = this.function();
        }
        if (k1 == null) {
            k1 = this.varConst();
        }
        if (k1 != null) {
            char c = this.getNextChar();
            while (c == '^') {
                ++this.nci;
                Knoten k2 = this.vFactor();
                if (k2 == null) {
                    return null;
                }
                k1 = new Knoten(6, 0.0, k1, k2);
                c = this.getNextChar();
            }
            return k1;
        }
        return null;
    }

    private Knoten vFactor() {
        int c = this.getNextChar();
        if (c == 43 || c == 45) {
            ++this.nci;
        } else {
            c = 43;
        }
        Knoten k1 = this.potenz();
        if (k1 != null) {
            if (c == 45) {
                k1 = new Knoten(7, 0.0, k1, null);
            }
            if ((c = (int)this.getNextChar()) == 176) {
                ++this.nci;
                k1 = new Knoten(50, 0.0, k1, null);
            }
            return k1;
        }
        return null;
    }

    private Knoten prod() {
        Knoten k1 = this.vFactor();
        if (k1 != null) {
            char c = this.getNextChar();
            while (c == '*' || c == '/') {
                ++this.nci;
                Knoten k2 = this.vFactor();
                if (k2 != null) {
                    k1 = c == '*' ? new Knoten(4, 0.0, k1, k2) : new Knoten(5, 0.0, k1, k2);
                    c = this.getNextChar();
                    continue;
                }
                return null;
            }
            return k1;
        }
        return null;
    }

    private Knoten sum() {
        Knoten k1 = this.prod();
        if (k1 != null) {
            char c = this.getNextChar();
            while (c == '+' || c == '-') {
                ++this.nci;
                Knoten k2 = this.prod();
                if (k2 != null) {
                    k1 = c == '+' ? new Knoten(2, 0.0, k1, k2) : new Knoten(3, 0.0, k1, k2);
                    c = this.getNextChar();
                    continue;
                }
                return null;
            }
            return k1;
        }
        return null;
    }

    private void regTP(Knoten knot, GeoObj owner) {
        if (knot != null) {
            switch (knot.token) {
                case 30: {
                    ((BoolTermTree)knot.leftCh).registerTermParentsIn(owner);
                    ((TermTree)knot.getRightCh().leftCh).registerTermParentsIn(owner);
                    if ((TermTree)knot.getRightCh().rightCh == null) break;
                    ((TermTree)knot.getRightCh().rightCh).registerTermParentsIn(owner);
                    break;
                }
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: {
                    GeoObj go = this.drawing.getObjectById((int)Math.round(knot.value));
                    if (go == null) break;
                    owner.becomesChildOf(go);
                    break;
                }
                case 48: {
                    GeoObj go = this.drawing.getObjectById((int)Math.round(knot.value));
                    if (go != null) {
                        owner.becomesChildOf(go);
                    }
                    if ((go = this.drawing.getObjectById((int)Math.round(knot.value))) != null) {
                        owner.becomesChildOf(go);
                    }
                    if ((go = this.drawing.getObjectById((int)Math.round(knot.value))) != null) {
                        owner.becomesChildOf(go);
                    }
                    return;
                }
                default: {
                    this.regTP(knot.getLeftCh(), owner);
                    this.regTP(knot.getRightCh(), owner);
                }
            }
        }
    }

    private void unregTP(Knoten knot, GeoObj owner) {
        if (knot != null) {
            switch (knot.token) {
                case 30: {
                    ((BoolTermTree)knot.leftCh).unregisterTermParentsIn(owner);
                    ((TermTree)knot.getRightCh().leftCh).unregisterTermParentsIn(owner);
                    if ((TermTree)knot.getRightCh().rightCh == null) break;
                    ((TermTree)knot.getRightCh().rightCh).unregisterTermParentsIn(owner);
                    break;
                }
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: {
                    GeoObj go = this.drawing.getObjectById((int)Math.round(knot.value));
                    if (go != null) {
                        owner.stopsToBeChildOf(go);
                    }
                }
                case 48: {
                    GeoObj go = this.drawing.getObjectById((int)Math.round(knot.value));
                    if (go != null) {
                        owner.stopsToBeChildOf(go);
                    }
                    if ((go = this.drawing.getObjectById((int)Math.round(knot.value))) != null) {
                        owner.stopsToBeChildOf(go);
                    }
                    if ((go = this.drawing.getObjectById((int)Math.round(knot.value))) != null) {
                        owner.stopsToBeChildOf(go);
                    }
                    return;
                }
                default: {
                    this.unregTP(knot.getLeftCh(), owner);
                    this.unregTP(knot.getRightCh(), owner);
                }
            }
        }
    }

    private Knoten derive(Knoten tb) {
        Knoten res = null;
        this.fDiffStat = 2;
        switch (tb.token) {
            case 0: {
                res = new Knoten(0, 0.0, null, null);
                break;
            }
            case 1: {
                if (Math.rint(tb.value) == 0.0) {
                    res = new Knoten(0, 1.0, null, null);
                    break;
                }
                res = new Knoten(0, 0.0, null, null);
                break;
            }
            case 2: 
            case 3: {
                res = new Knoten(tb.token, 0.0, this.derive(tb.getLeftCh()), this.derive(tb.getRightCh()));
                break;
            }
            case 4: {
                if (((Knoten)tb.rightCh).token == 0) {
                    tb.switchChildren();
                }
                if (((Knoten)tb.leftCh).token == 0) {
                    res = new Knoten(4, 0.0, Knoten.copyKnot(tb.getLeftCh()), this.derive(tb.getRightCh()));
                    break;
                }
                res = new Knoten(2, 0.0, new Knoten(4, 0.0, this.derive(tb.getLeftCh()), Knoten.copyKnot(tb.getRightCh())), new Knoten(4, 0.0, Knoten.copyKnot(tb.getLeftCh()), this.derive(tb.getRightCh())));
                break;
            }
            case 5: {
                if (tb.getRightCh().token == 0) {
                    res = new Knoten(5, 0.0, this.derive(tb.getLeftCh()), Knoten.copyKnot(tb.getRightCh()));
                    break;
                }
                res = new Knoten(5, 0.0, new Knoten(8, 0.0, new Knoten(3, 0.0, new Knoten(4, 0.0, this.derive(tb.getLeftCh()), Knoten.copyKnot(tb.getRightCh())), new Knoten(4, 0.0, this.derive(tb.getRightCh()), Knoten.copyKnot(tb.getLeftCh()))), null), new Knoten(18, 0.0, null, Knoten.copyKnot(tb.getRightCh())));
                break;
            }
            case 6: {
                if (tb.getLeftCh().token == 0) {
                    res = new Knoten(4, 0.0, Knoten.copyKnot(tb), new Knoten(4, 0.0, this.derive(tb.getRightCh()), new Knoten(12, 0.0, null, Knoten.copyKnot(tb.getLeftCh()))));
                    break;
                }
                if (tb.getLeftCh().token == 1) {
                    if (tb.getRightCh().token == 0) {
                        if (Math.abs(tb.getRightCh().value - 1.0) < 1.0E-12) {
                            res = new Knoten(0, 1.0, null, null);
                            break;
                        }
                        if (Math.abs(tb.getRightCh().value - 2.0) < 1.0E-12) {
                            res = new Knoten(4, 0.0, Knoten.copyKnot(tb.getRightCh()), new Knoten(1, 0.0, null, null));
                            break;
                        }
                        res = new Knoten(4, 0.0, Knoten.copyKnot(tb.getRightCh()), new Knoten(6, 0.0, new Knoten(1, 0.0, null, null), new Knoten(0, tb.getRightCh().value - 1.0, null, null)));
                        break;
                    }
                    res = new Knoten(4, 0.0, Knoten.copyKnot(tb), new Knoten(8, 0.0, new Knoten(2, 0.0, new Knoten(4, 0.0, this.derive(tb.getRightCh()), new Knoten(12, 0.0, null, new Knoten(1, 0.0, null, null))), new Knoten(5, 0.0, Knoten.copyKnot(tb.getRightCh()), new Knoten(1, 0.0, null, null))), null));
                    break;
                }
                if (tb.getRightCh().token == 0) {
                    if (Math.abs(tb.getRightCh().value - 1.0) < 1.0E-12) {
                        res = this.derive(tb.getLeftCh());
                        break;
                    }
                    if (Math.abs(tb.getRightCh().value - 2.0) < 1.0E-12) {
                        res = new Knoten(4, 0.0, Knoten.copyKnot(tb.getRightCh()), new Knoten(4, 0.0, Knoten.copyKnot(tb.getLeftCh()), this.derive(tb.getLeftCh())));
                        break;
                    }
                    res = new Knoten(4, 0.0, Knoten.copyKnot(tb.getRightCh()), new Knoten(4, 0.0, new Knoten(6, 0.0, Knoten.copyKnot(tb.getLeftCh()), new Knoten(0, tb.getRightCh().value - 1.0, null, null)), this.derive(tb.getLeftCh())));
                    break;
                }
                res = new Knoten(4, 0.0, Knoten.copyKnot(tb), new Knoten(8, 0.0, new Knoten(2, 0.0, new Knoten(4, 0.0, this.derive(tb.getRightCh()), new Knoten(12, 0.0, null, Knoten.copyKnot(tb.getLeftCh()))), new Knoten(4, 0.0, Knoten.copyKnot(tb.getRightCh()), new Knoten(5, 0.0, this.derive(tb.getLeftCh()), Knoten.copyKnot(tb.getLeftCh())))), null));
                break;
            }
            case 7: 
            case 8: {
                res = new Knoten(tb.token, 0.0, this.derive(tb.getLeftCh()), null);
                break;
            }
            case 9: {
                res = new Knoten(4, 0.0, new Knoten(0, 2.0, null, null), new Knoten(4, 0.0, this.derive(tb.getLeftCh()), Knoten.copyKnot(tb.getLeftCh())));
                break;
            }
            case 10: {
                res = new Knoten(5, 0.0, this.derive(tb.getLeftCh()), new Knoten(4, 0.0, new Knoten(0, 2.0, null, null), Knoten.copyKnot(tb)));
                break;
            }
            case 11: {
                res = new Knoten(4, 0.0, new Knoten(0, 1.0 / Math.log(10.0), null, null), new Knoten(5, 0.0, this.derive(tb.getLeftCh()), Knoten.copyKnot(tb.getLeftCh())));
                break;
            }
            case 12: {
                res = new Knoten(5, 0.0, this.derive(tb.getLeftCh()), Knoten.copyKnot(tb.getLeftCh()));
                break;
            }
            case 13: {
                res = new Knoten(4, 0.0, this.derive(tb.getLeftCh()), Knoten.copyKnot(tb));
                break;
            }
            case 14: {
                res = new Knoten(4, 0.0, this.derive(tb.getLeftCh()), new Knoten(15, 0.0, Knoten.copyKnot(tb.getLeftCh()), null));
                break;
            }
            case 15: {
                res = new Knoten(4, 0.0, this.derive(tb.getLeftCh()), new Knoten(7, 0.0, new Knoten(14, 0.0, Knoten.copyKnot(tb.getLeftCh()), null), null));
                break;
            }
            case 16: {
                res = new Knoten(5, 0.0, this.derive(tb.getLeftCh()), new Knoten(9, 0.0, new Knoten(15, 0.0, Knoten.copyKnot(tb.getLeftCh()), null), null));
                break;
            }
            case 17: {
                res = new Knoten(5, 0.0, this.derive(tb.getLeftCh()), new Knoten(2, 0.0, new Knoten(0, 1.0, null, null), new Knoten(9, 0.0, Knoten.copyKnot(tb.getLeftCh()), null)));
                break;
            }
            case 18: {
                res = new Knoten(4, 0.0, new Knoten(19, 0.0, Knoten.copyKnot(tb.getLeftCh()), null), this.derive(tb.getLeftCh()));
                break;
            }
            case 19: 
            case 20: 
            case 25: 
            case 27: 
            case 28: {
                res = new Knoten(0, 0.0, null, null);
                break;
            }
            case 21: {
                res = new Knoten(5, 0.0, this.derive(tb.getLeftCh()), new Knoten(10, 0.0, new Knoten(3, 0.0, new Knoten(0, 1.0, null, null), new Knoten(9, 0.0, Knoten.copyKnot(tb.getLeftCh()), null)), null));
                break;
            }
            case 22: {
                res = new Knoten(5, 0.0, new Knoten(7, 0.0, this.derive(tb.getLeftCh()), null), new Knoten(10, 0.0, new Knoten(3, 0.0, new Knoten(0, 1.0, null, null), new Knoten(9, 0.0, Knoten.copyKnot(tb.getLeftCh()), null)), null));
                break;
            }
            case 23: {
                res = new Knoten(4, 0.0, new Knoten(0, 57.29577951308232, null, null), this.derive(tb.getLeftCh()));
                break;
            }
            case 24: {
                res = new Knoten(4, 0.0, new Knoten(0, Math.PI / 180, null, null), this.derive(tb.getLeftCh()));
                break;
            }
            case 26: {
                res = this.derive(tb.getLeftCh());
                break;
            }
            case 29: {
                res = null;
                break;
            }
            case 30: {
                BoolTermTree cloneBTT = ((BoolTermTree)tb.leftCh).createCopy();
                TermTree diff_rlc = this.createDerivativeOf((TermTree)tb.getRightCh().leftCh);
                TermTree diff_rrc = null;
                if (tb.getRightCh().rightCh != null) {
                    diff_rrc = this.createDerivativeOf((TermTree)tb.getRightCh().rightCh);
                }
                res = new Knoten(tb.token, cloneBTT, new Knoten(tb.getRightCh().token, diff_rlc, diff_rrc, 0));
                break;
            }
            default: {
                res = new Knoten(0, 0.0, null, null);
            }
        }
        if (res == null) {
            this.fDiffStat = 0;
        }
        return res;
    }
}

