/*
 * Decompiled with CFR 0.152.
 */
package xml;

import applet.Options;
import canvas.CoordsCanvas;
import dgmath.MyMath;
import geoobj.GeoObj;
import geoobj.GeoObjList;
import java.awt.Font;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import xml.FontSettings;
import xml.HeaderData;
import xml.ObjectFactory;
import xml.WindowData;

public class DynaGeoFileIO {
    private Document document;
    private GeoObjList objects = new GeoObjList();
    private WindowData window = new WindowData();
    private HeaderData header = new HeaderData();

    public DynaGeoFileIO(InputStream is) {
        try {
            System.out.println("DynaGeoFileIO: Screen: wx = " + Integer.toString(Options.ori_drawWin_width) + "; wy = " + Integer.toString(Options.ori_drawWin_height));
            this.parse(is);
            this.document.normalizeDocument();
            this.readHeaderDataFromXML();
            this.readWindowDataFromXML();
            this.window.cut2size(Options.ori_drawWin_width, Options.ori_drawWin_height);
            this.readObjectsFromXML();
            this.readGroupsFromXML();
        }
        catch (IOException e) {
            System.err.print("Error reading data from XML input stream:\n" + e.getMessage());
        }
        catch (SAXException e) {
            System.err.println("Syntax error in XML data:\n" + e.getMessage());
        }
    }

    public GeoObjList getObjectList() {
        return this.objects;
    }

    public WindowData getWindowData() {
        return (WindowData)this.window.clone();
    }

    public HeaderData getHeaderData() {
        return (HeaderData)this.header.clone();
    }

    public void updateWindowData(CoordsCanvas canvas) {
        double[] data = canvas.getCoordsRange();
        this.window.setWindowCoordinates(data[0], data[2], data[1], data[3]);
        this.window.setWidth(canvas.userToScreenW(data[2] - data[0]));
        this.window.setHeight(canvas.userToScreenH(data[3] - data[1]));
    }

    public Document createDomDocFromObjects(GeoObjList drawing) {
        try {
            this.objects = drawing;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.newDocument();
            Element root = this.document.createElement("dg:drawing");
            root.setAttribute("xmlns:dg", "http://dynageo.com/xml/dg12");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            root.setAttribute("xsi:schemaLocation", "http://www.dynageo.com/xml/dg12 http://www.dynageo.com/xml/dg12.xsd");
            Element header = this.buildHeaderNode(this.document);
            root.appendChild(header);
            Element window = this.buildWindowNode(this.document);
            root.appendChild(window);
            Element objlist = this.buildObjectNode(this.document);
            root.appendChild(objlist);
            Element grouplist = this.buildGroupNode(this.document);
            if (grouplist != null) {
                root.appendChild(grouplist);
            }
            this.document.appendChild(root);
            this.document.normalize();
            return this.document;
        }
        catch (ParserConfigurationException e) {
            System.err.print("Error building XML document:\n" + e.getMessage());
            return null;
        }
    }

    public boolean writeDOMDataToFileStream(OutputStream os) {
        boolean res = false;
        try {
            DOMSource source = new DOMSource(this.document);
            StreamResult result = new StreamResult(os);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer serializer = transformerFactory.newTransformer();
            serializer.setOutputProperty("method", "xml");
            serializer.setOutputProperty("encoding", "UTF-8");
            serializer.setOutputProperty("indent", "yes");
            serializer.transform(source, result);
            os.flush();
            os.close();
            res = true;
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Unsupported XML encoding:\n" + e.getMessage());
        }
        catch (TransformerConfigurationException e) {
            System.err.println("Error configuring DOM2XML serializer:\n" + e.getMessage());
        }
        catch (TransformerException e) {
            System.err.println("Error transforming DOM data to XML file:\n" + e.getMessage());
        }
        catch (IOException e) {
            System.err.println("Error writing DynaGeo file:\n" + e.getMessage());
        }
        return res;
    }

    private void parse(InputStream is) throws SAXException, IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.parse(is);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("XML parser exception caught!", e);
        }
    }

    private void readHeaderDataFromXML() {
        NodeList headerDataNodeList = this.document.getElementsByTagName("header");
        Node headerDataNode = headerDataNodeList.item(0);
        NodeList childNodes = headerDataNode.getChildNodes();
        int n = childNodes.getLength();
        int e = 0;
        while (e < n) {
            Node current = childNodes.item(e);
            String attribute = current.getNodeName();
            if (attribute.equalsIgnoreCase("created")) {
                this.header.setCreatedName(current.getAttributes().getNamedItem("prog_name").getNodeValue());
                if (current.getAttributes().getNamedItem("prog_version") != null) {
                    this.header.setCreatedVersion(current.getAttributes().getNamedItem("prog_version").getNodeValue());
                }
                if (current.getAttributes().getNamedItem("date") != null) {
                    this.header.setCreatedDate(current.getAttributes().getNamedItem("date").getNodeValue());
                }
            } else if (attribute.equalsIgnoreCase("edited")) {
                this.header.setEditedName(current.getAttributes().getNamedItem("prog_name").getNodeValue());
                if (current.getAttributes().getNamedItem("prog_version") != null) {
                    this.header.setEditedVersion(current.getAttributes().getNamedItem("prog_version").getNodeValue());
                }
                if (current.getAttributes().getNamedItem("date") != null) {
                    this.header.setEditedDate(current.getAttributes().getNamedItem("date").getNodeValue());
                }
            } else if (attribute.equalsIgnoreCase("copyright")) {
                if (current.getAttributes().getNamedItem("sign_code") != null) {
                    this.header.setSignCode(current.getAttributes().getNamedItem("sign_code").getNodeValue());
                }
                this.header.setCopyright(current.getChildNodes().item(0).getNodeValue().trim());
            } else if (attribute.equalsIgnoreCase("environment")) {
                NodeList envNodes = current.getChildNodes();
                int i = 0;
                while (i < envNodes.getLength()) {
                    String data;
                    if (envNodes.item(i).getNodeName().equals("commands") && (data = envNodes.item(i).getFirstChild().getNodeValue()) != null && (data = data.trim()) != null) {
                        this.header.setCommands(data);
                    }
                    if (envNodes.item(i).getNodeName().equals("links")) {
                        this.header.setLinkLast(envNodes.item(i).getAttributes().getNamedItem("back").getNodeValue());
                        this.header.setLinkNext(envNodes.item(i).getAttributes().getNamedItem("links").getNodeValue());
                    }
                    ++i;
                }
            }
            ++e;
        }
    }

    private void readWindowDataFromXML() {
        NodeList windowDataNodeList = this.document.getElementsByTagName("windowdata");
        Node windowDataNode = windowDataNodeList.item(0);
        NodeList childNodes = windowDataNode.getChildNodes();
        int e = 0;
        while (e < childNodes.getLength()) {
            Node childNode = childNodes.item(e);
            String childName = childNode.getNodeName();
            if (childName.equalsIgnoreCase("log_window")) {
                double xmin = Double.parseDouble(childNode.getAttributes().getNamedItem("xmin").getNodeValue());
                double ymin = Double.parseDouble(childNode.getAttributes().getNamedItem("ymin").getNodeValue());
                double xmax = Double.parseDouble(childNode.getAttributes().getNamedItem("xmax").getNodeValue());
                double ymax = Double.parseDouble(childNode.getAttributes().getNamedItem("ymax").getNodeValue());
                this.window.setWindowCoordinates(xmin, xmax, ymin, ymax);
            } else if (childName.equalsIgnoreCase("scr_window")) {
                this.window.setWidth(Integer.parseInt(childNode.getAttributes().getNamedItem("width").getNodeValue()));
                this.window.setHeight(Integer.parseInt(childNode.getAttributes().getNamedItem("height").getNodeValue()));
            } else if (childName.equalsIgnoreCase("back_col")) {
                this.window.setColor(childNode.getChildNodes().item(0).getNodeValue());
            } else if (childName.equalsIgnoreCase("startfont")) {
                boolean bold = false;
                boolean italic = false;
                boolean underline = false;
                boolean strikeout = false;
                String fontName = "Arial";
                int fontSize = 12;
                int fontCharset = 0;
                if (childNode.getAttributes().getNamedItem("fontname") != null) {
                    fontName = childNode.getAttributes().getNamedItem("fontname").getNodeValue();
                }
                if (childNode.getAttributes().getNamedItem("fontsize") != null) {
                    Options.oriDefaultFontSize = childNode.getAttributes().getNamedItem("fontsize").getNodeValue();
                    fontSize = Integer.parseInt(Options.oriDefaultFontSize);
                }
                if (childNode.getAttributes().getNamedItem("fontcharset") != null) {
                    fontCharset = Integer.parseInt(childNode.getAttributes().getNamedItem("fontcharset").getNodeValue());
                }
                if (childNode.getAttributes().getNamedItem("attr_bold") != null && childNode.getAttributes().getNamedItem("attr_bold").getNodeValue().equalsIgnoreCase("true")) {
                    bold = true;
                }
                if (childNode.getAttributes().getNamedItem("attr_italic") != null && childNode.getAttributes().getNamedItem("attr_italic").getNodeValue().equalsIgnoreCase("true")) {
                    italic = true;
                }
                if (childNode.getAttributes().getNamedItem("attr_underline") != null && childNode.getAttributes().getNamedItem("attr_underline").getNodeValue().equalsIgnoreCase("true")) {
                    underline = true;
                }
                if (childNode.getAttributes().getNamedItem("attr_strikeout") != null && childNode.getAttributes().getNamedItem("attr_strikeout").getNodeValue().equalsIgnoreCase("true")) {
                    strikeout = true;
                }
                this.window.setFont(new FontSettings(fontName, fontSize, fontCharset, bold, italic, underline, strikeout));
            } else if (childName.equalsIgnoreCase("options")) {
                if (childNode.getAttributes().getNamedItem("LengthDecimals") != null) {
                    Options.lengthDecimals = Integer.parseInt(childNode.getAttributes().getNamedItem("LengthDecimals").getNodeValue());
                }
                if (childNode.getAttributes().getNamedItem("AreaDecimals") != null) {
                    Options.areaDecimals = Integer.parseInt(childNode.getAttributes().getNamedItem("AreaDecimals").getNodeValue());
                }
                if (childNode.getAttributes().getNamedItem("AngleDecimals") != null) {
                    Options.angleDecimals = Integer.parseInt(childNode.getAttributes().getNamedItem("AngleDecimals").getNodeValue());
                }
                if (childNode.getAttributes().getNamedItem("LengthUnit") != null) {
                    Options.lengthUnit = childNode.getAttributes().getNamedItem("LengthUnit").getNodeValue();
                }
                if (childNode.getAttributes().getNamedItem("AreaUnit") != null) {
                    Options.areaUnit = childNode.getAttributes().getNamedItem("AreaUnit").getNodeValue();
                }
                if (childNode.getAttributes().getNamedItem("AngleUnit") != null) {
                    Options.angleUnit = childNode.getAttributes().getNamedItem("AngleUnit").getNodeValue();
                }
                if (childNode.getAttributes().getNamedItem("SignedAngles") != null) {
                    Options.signedAngles = childNode.getAttributes().getNamedItem("SignedAngles").getNodeValue().equalsIgnoreCase("true");
                }
                if (childNode.getAttributes().getNamedItem("DefLocLineStatus") != null) {
                    Options.defLocLineStatus = Integer.parseInt(childNode.getAttributes().getNamedItem("DefLocLineStatus").getNodeValue());
                }
            }
            ++e;
        }
    }

    private void readObjectsFromXML() {
        Node attr;
        NodeList objListNodeList = this.document.getElementsByTagName("objlist");
        Node objListNode = objListNodeList.item(0);
        NodeList objNodes = objListNode.getChildNodes();
        int n = objNodes.getLength();
        int i = 0;
        while (i < n) {
            GeoObj obj;
            Node actNode = objNodes.item(i);
            if (!actNode.getNodeName().equalsIgnoreCase("#text") && (obj = ObjectFactory.createObject((Element)actNode, this.objects)) != null) {
                this.objects.insertGO(obj);
            }
            ++i;
        }
        NamedNodeMap attrlist = objListNode.getAttributes();
        if (attrlist != null && (attr = attrlist.getNamedItem("ani_source")) != null) {
            int asNum = Integer.parseInt(attr.getNodeValue());
            this.objects.setAniSource(asNum);
        }
        if (this.window.getFont() != null) {
            Font f = this.window.getFont().getFont();
            if (Math.abs(Options.fontScale - 1.0) > 1.0E-12) {
                this.objects.setStartFont(f.deriveFont((float)((double)f.getSize2D() * Options.fontScale)));
            } else {
                this.objects.setStartFont(f);
            }
        }
    }

    private void readGroupsFromXML() {
        NodeList objListNodeList = this.document.getElementsByTagName("grouplist");
        Element groupListNode = (Element)objListNodeList.item(0);
        if (groupListNode != null) {
            this.objects.loadVisGroups(groupListNode);
        }
    }

    private Element buildHeaderNode(Document domDoc) {
        Element headerNode = domDoc.createElement("header");
        Element created = domDoc.createElement("created");
        created.setAttribute("prog_name", this.header.getCreatedName());
        created.setAttribute("prog_version", this.header.getCreatedVersion());
        created.setAttribute("date", this.header.getCreatedDate());
        headerNode.appendChild(created);
        Element edited = domDoc.createElement("edited");
        edited.setAttribute("prog_name", "DynaGeoJ");
        edited.setAttribute("prog_version", "1.5.2.0");
        edited.setAttribute("date", MyMath.getNowStr());
        headerNode.appendChild(edited);
        if (this.header.getCopyright() != null && this.header.getCopyright().length() > 0) {
            Element copyRight = domDoc.createElement("copyright");
            copyRight.setAttribute("sign_code", this.header.getSignCode());
            copyRight.setTextContent(this.header.getCopyright());
            headerNode.appendChild(copyRight);
        }
        if (this.header.getCommands().length() > 0 || this.header.getLinkLast().length() > 0 || this.header.getLinkNext().length() > 0) {
            Element environ = domDoc.createElement("environment");
            if (this.header.getCommands().length() > 0) {
                Element commands = domDoc.createElement("commands");
                commands.setTextContent(this.header.getCommands());
                environ.appendChild(commands);
            }
            if (this.header.getLinkLast().length() > 0 || this.header.getLinkNext().length() > 0) {
                Element links = domDoc.createElement("links");
                if (this.header.getLinkLast().length() > 0) {
                    links.setAttribute("back", this.header.getLinkLast());
                }
                if (this.header.getLinkNext().length() > 0) {
                    links.setAttribute("forward", this.header.getLinkNext());
                }
                environ.appendChild(links);
            }
            headerNode.appendChild(environ);
        }
        return headerNode;
    }

    private Element buildWindowNode(Document domDoc) {
        Font actStartFont;
        Element windowDataNode = domDoc.createElement("windowdata");
        Element log_window = domDoc.createElement("log_window");
        log_window.setAttribute("xmin", new Double(this.window.getXmin()).toString());
        log_window.setAttribute("ymin", new Double(this.window.getYmin()).toString());
        log_window.setAttribute("xmax", new Double(this.window.getXmax()).toString());
        log_window.setAttribute("ymax", new Double(this.window.getYmax()).toString());
        windowDataNode.appendChild(log_window);
        Element screen_window = domDoc.createElement("scr_window");
        screen_window.setAttribute("width", new Integer(this.window.getWidth()).toString());
        screen_window.setAttribute("height", new Integer(this.window.getHeight()).toString());
        windowDataNode.appendChild(screen_window);
        if (this.window.getColor().getRGB() != 0) {
            windowDataNode.setAttribute("back_col", this.window.getHex8strColor());
        }
        if ((actStartFont = this.objects.getStartFont()).isBold() || actStartFont.isItalic() || !actStartFont.getFamily().equalsIgnoreCase("Arial") || actStartFont.getSize() != 12) {
            Element startfont = domDoc.createElement("startfont");
            if (!actStartFont.getFamily().equalsIgnoreCase("Arial")) {
                startfont.setAttribute("fontname", this.objects.getStartFont().getFontName());
            }
            if (actStartFont.isBold()) {
                startfont.setAttribute("attr_bold", "true");
            }
            if (actStartFont.isItalic()) {
                startfont.setAttribute("attr_italic", "true");
            }
            if (!Options.oriDefaultFontSize.equals("12")) {
                startfont.setAttribute("fontsize", Options.oriDefaultFontSize);
            }
            windowDataNode.appendChild(startfont);
        }
        if (Options.anyOptionChanged()) {
            Element options = domDoc.createElement("options");
            if (Options.lengthDecimals != 3) {
                options.setAttribute("LengthDecimals", String.valueOf(Options.lengthDecimals));
            }
            if (Options.areaDecimals != 2) {
                options.setAttribute("AreaDecimals", String.valueOf(Options.areaDecimals));
            }
            if (Options.angleDecimals != 1) {
                options.setAttribute("AngleDecimals", String.valueOf(Options.angleDecimals));
            }
            if (!Options.lengthUnit.equals(" cm ")) {
                options.setAttribute("LengthUnit", Options.lengthUnit);
            }
            if (!Options.areaUnit.equals(" cm\u00b2 ")) {
                options.setAttribute("AreaUnit", Options.areaUnit);
            }
            if (!Options.angleUnit.equals(" \u00b0 ")) {
                options.setAttribute("AngleUnit", Options.angleUnit);
            }
            if (!Options.signedAngles) {
                options.setAttribute("SignedAngles", "false");
            }
            if (Options.defLocLineStatus != 7) {
                options.setAttribute("DefLocLineStatus", String.valueOf(Options.defLocLineStatus));
            }
            windowDataNode.appendChild(options);
        }
        return windowDataNode;
    }

    private Element buildObjectNode(Document domDoc) {
        Element objectsNode = domDoc.createElement("objlist");
        GeoObj ani_source = this.objects.getAniSource();
        if (ani_source != null) {
            objectsNode.setAttribute("ani_source", String.valueOf(ani_source.getId()));
        }
        Element objNode = null;
        int i = 0;
        while (i < this.objects.size()) {
            objNode = this.objects.get(i).createDomNode(domDoc);
            objectsNode.appendChild(objNode);
            ++i;
        }
        return objectsNode;
    }

    private Element buildGroupNode(Document domDoc) {
        Element groupNode = this.objects.getVisGroups().createDomNode(domDoc);
        return groupNode;
    }
}

