/*
 * Decompiled with CFR 0.152.
 */
package xml;

import applet.Options;
import dgmath.MyStack;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;

public class FormattedString
extends HTMLEditorKit.ParserCallback {
    protected ParserDelegator parser;
    protected ArrayList<FormattedAtom> atoms;
    protected Font actFont;
    protected SimpleAttributeSet actAttribs;
    protected int actYOffset = 0;
    protected MyStack FormatStack = new MyStack();
    protected int ascent = 0;
    protected int descent = 0;
    protected int leading = 0;
    protected int width = 0;
    protected int height = 0;

    public FormattedString(Font iStartFont, String iHtmlStr) {
        this.atoms = new ArrayList();
        this.actFont = iStartFont != null ? iStartFont : new Font("SansSerif", 0, (int)(10.0 * Options.fontScale));
        this.actAttribs = new SimpleAttributeSet(SimpleAttributeSet.EMPTY);
        this.loadDataFrom(iHtmlStr);
    }

    public void loadDataFrom(String iHtmlStr) {
        this.parser = new ParserDelegator();
        StringReader reader = new StringReader(iHtmlStr);
        try {
            this.parser.parse(reader, this, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        if (t.equals(HTML.Tag.B)) {
            this.pushFormat();
            this.actFont = this.actFont.deriveFont(1);
        } else if (t.equals(HTML.Tag.I)) {
            this.pushFormat();
            this.actFont = this.actFont.deriveFont(2);
        } else if (t.equals(HTML.Tag.U)) {
            this.pushFormat();
            this.actAttribs.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        } else if (t.equals(HTML.Tag.SUB)) {
            this.pushFormat();
            int fs = this.actFont.getSize();
            this.actFont = this.actFont.deriveFont((float)((double)fs * 0.66666));
            this.actYOffset = (int)((double)fs * 0.25);
        } else if (t.equals(HTML.Tag.SUP)) {
            this.pushFormat();
            int fs = this.actFont.getSize();
            this.actFont = this.actFont.deriveFont((float)((double)fs * 0.66666));
            this.actYOffset = (int)((double)(-fs) * 0.6);
        } else if (t.equals(HTML.Tag.FONT)) {
            float ns;
            this.pushFormat();
            Object ao = a.getAttribute(HTML.Attribute.SIZE);
            if (ao == null) {
                ns = (float)(Options.fontScale * 12.0);
                this.actFont = this.actFont.deriveFont(ns);
            } else {
                ns = (float)(Options.fontScale * (double)Float.parseFloat(ao.toString()));
                this.actFont = this.actFont.deriveFont(ns);
            }
            ao = a.getAttribute(HTML.Attribute.FACE);
            String nName = "Arial";
            if (ao != null) {
                nName = ao.toString();
            }
            int nStyle = this.actFont.getStyle();
            int nSize = this.actFont.getSize();
            this.actFont = new Font(nName, nStyle, nSize);
        }
    }

    @Override
    public void handleEndTag(HTML.Tag t, int pos) {
        if (t.equals(HTML.Tag.B) || t.equals(HTML.Tag.I) || t.equals(HTML.Tag.U) || t.equals(HTML.Tag.SUB) || t.equals(HTML.Tag.SUP) || t.equals(HTML.Tag.FONT)) {
            this.popFormat();
        }
    }

    @Override
    public void handleText(char[] data, int pos) {
        String text = new String(data);
        FormattedAtom newEntry = new FormattedAtom(text, this.actFont, this.actAttribs, this.actYOffset);
        this.atoms.add(newEntry);
    }

    public Point2D measureExts(Graphics2D canvas) {
        this.width = this.measureHorizontalExt(canvas);
        this.height = this.measureVerticalExts(canvas);
        Point2D.Double res = new Point2D.Double(this.width, this.height);
        return res;
    }

    public FormattedString cut2size(Graphics2D canvas, int lineSize) {
        FormattedString rest = null;
        FormattedAtom item = null;
        int len = this.measureHorizontalExt(canvas);
        if (len > lineSize) {
            int rem_sp;
            FontRenderContext frc = canvas.getFontRenderContext();
            Rectangle2D sb = new Rectangle2D.Float();
            int width = 0;
            int i = -1;
            while (width <= lineSize) {
                item = this.atoms.get(++i);
                canvas.setFont(item.font);
                sb = item.font.getStringBounds(item.text, frc);
                width += (int)sb.getWidth();
            }
            FormattedAtom ra = item.cut2Size(canvas, i > 0, rem_sp = lineSize - (width - (int)sb.getWidth()));
            if (ra != null) {
                rest = new FormattedString();
                ra.text = ra.text.trim();
                rest.atoms.add(ra);
                int n = i + 1;
                while (n < this.atoms.size()) {
                    rest.atoms.add(this.atoms.get(n));
                    ++n;
                }
                n = this.atoms.size() - 1;
                while (n > i) {
                    this.atoms.remove(n);
                    --n;
                }
                if (item.text.length() <= 0) {
                    this.atoms.remove(item);
                }
            }
        }
        return rest;
    }

    public void draw(Graphics2D canvas, int sx, int sy, Point2D bounds) {
        int rx = sx;
        int ry = sy + this.ascent;
        FontRenderContext frc = canvas.getFontRenderContext();
        if (this.atoms.size() > 0) {
            int i = 0;
            while (i < this.atoms.size()) {
                FormattedAtom item = this.atoms.get(i);
                String actFontName = item.getFont().getFontName();
                if (actFontName.equalsIgnoreCase("Arial") || actFontName.equalsIgnoreCase("Symbol")) {
                    canvas.setFont(new Font("SansSerif", item.getFont().getStyle(), item.getFont().getSize()));
                } else {
                    canvas.setFont(item.getFont());
                }
                String actText = actFontName.equalsIgnoreCase("Symbol") ? item.getTransposedText() : item.getText();
                Rectangle2D sb = item.font.getStringBounds(actText, frc);
                canvas.drawString(actText, rx, ry + item.yOffset);
                if (item.getAttribs().containsAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON)) {
                    if (this.actFont.isBold() || this.actFont.getSize() > 25) {
                        BasicStroke s = new BasicStroke(2.0f, 0, 0);
                        canvas.setStroke(s);
                    }
                    canvas.drawLine(rx + 1, ry + this.descent - 1, rx + (int)sb.getWidth() - 1, ry + this.descent - 1);
                }
                rx += (int)sb.getWidth();
                ++i;
            }
            bounds.setLocation(rx - sx, ry - sy + this.descent);
        } else {
            Rectangle2D sb = this.actFont.getMaxCharBounds(frc);
            bounds.setLocation(0.0, sb.getHeight());
        }
    }

    private FormattedString() {
        this.atoms = new ArrayList();
    }

    protected void pushFormat() {
        FormattedAtom formatEntry = new FormattedAtom("", this.actFont, this.actAttribs, this.actYOffset);
        this.FormatStack.pushObj(formatEntry);
    }

    protected void popFormat() {
        FormattedAtom formatEntry = (FormattedAtom)this.FormatStack.popObj();
        this.actFont = formatEntry.font;
        this.actAttribs = formatEntry.attribs;
        this.actYOffset = formatEntry.yOffset;
    }

    private int measureVerticalExts(Graphics2D canvas) {
        int i = 0;
        while (i < this.atoms.size()) {
            FormattedAtom item = this.atoms.get(i);
            FontMetrics fm = canvas.getFontMetrics(item.font);
            int na = fm.getAscent();
            int nd = fm.getDescent();
            int nl = fm.getLeading();
            if (item.yOffset < 0) {
                na -= item.yOffset;
            } else if (item.yOffset > 0) {
                nd += item.yOffset;
            }
            if (na > this.ascent) {
                this.ascent = na;
            }
            if (nd > this.descent) {
                this.descent = nd;
            }
            if (nl > this.leading) {
                this.leading = nl;
            }
            ++i;
        }
        return this.ascent + this.descent + this.leading;
    }

    private int measureHorizontalExt(Graphics2D canvas) {
        int w = 0;
        FontRenderContext frc = canvas.getFontRenderContext();
        int i = 0;
        while (i < this.atoms.size()) {
            FormattedAtom item = this.atoms.get(i);
            canvas.setFont(item.font);
            Rectangle2D sb = item.font.getStringBounds(item.text, frc);
            w += (int)sb.getWidth();
            ++i;
        }
        return w;
    }

    protected class FormattedAtom {
        private String text;
        private Font font;
        private SimpleAttributeSet attribs;
        private int yOffset;
        private final char[] symbol = new char[]{'\u0391', '\u0392', '\u03a7', '\u0394', '\u0395', '\u03a6', '\u0393', '\u0397', '\u0399', '\u0398', '\u039a', '\u039b', '\u039c', '\u039d', '\u039f', '\u03a0', '\u0398', '\u03a1', '\u03a3', '\u03a4', '\u03a5', '\u03c2', '\u03a9', '\u039e', '\u03a8', '\u0396', '[', ' ', ']', '^', '_', '\u00af', '\u03b1', '\u03b2', '\u03c7', '\u03b4', '\u03b5', '\u03c6', '\u03b3', '\u03b7', '\u03b9', '\u03c6', '\u03ba', '\u03bb', '\u03bc', '\u03bd', '\u03bf', '\u03c0', '\u0398', '\u03c1', '\u03c3', '\u03c4', '\u03c5', '\u03c9', '\u03c9', '\u03be', '\u03c8', '\u03b6', '{', '|', '}', '~'};

        public FormattedAtom(String iText, Font iFont, SimpleAttributeSet iAttribs, int iYOffset) {
            this.text = iText;
            this.font = iFont;
            this.setAttribs((SimpleAttributeSet)iAttribs.clone());
            this.yOffset = iYOffset;
        }

        public FormattedAtom cut2Size(Graphics2D canvas, boolean emptyAllowed, int rem_sp) {
            FontRenderContext frc = canvas.getFontRenderContext();
            StringBuilder sb = new StringBuilder(this.text);
            int n = sb.length();
            int need_sp = rem_sp + 1;
            do {
                if ((n = sb.lastIndexOf(" ", n - 1)) <= 0) continue;
                need_sp = (int)this.font.getStringBounds(sb.substring(0, n), frc).getWidth();
            } while (n >= 0 && need_sp > rem_sp);
            if (n <= 0) {
                if (emptyAllowed) {
                    FormattedAtom ra = new FormattedAtom(this.text, this.font, this.attribs, this.yOffset);
                    this.text = "";
                    return ra;
                }
                n = 0;
                do {
                    need_sp = (int)this.font.getStringBounds(sb.substring(0, ++n), frc).getWidth();
                } while (n < sb.length() && need_sp <= rem_sp);
                n = n > 1 ? --n : 1;
            }
            this.text = sb.substring(0, n);
            String restText = sb.substring(n, sb.length()).trim();
            FormattedAtom ra = new FormattedAtom(restText, this.font, this.attribs, this.yOffset);
            return ra;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public Font getFont() {
            return this.font;
        }

        public void setYOffset(int yOffset) {
            this.yOffset = yOffset;
        }

        public int getYOffset() {
            return this.yOffset;
        }

        public void setAttribs(SimpleAttributeSet attribs) {
            this.attribs = attribs;
        }

        public SimpleAttributeSet getAttribs() {
            return this.attribs;
        }

        public String getTransposedText() {
            StringBuilder buf = new StringBuilder(this.text);
            int i = 0;
            while (i < buf.length()) {
                int n;
                char c = buf.charAt(i);
                if (Character.isLetter(c) && (n = c - 65) >= 0 && n < this.symbol.length) {
                    c = this.symbol[n];
                }
                buf.setCharAt(i, c);
                ++i;
            }
            return buf.toString();
        }
    }
}

