/*
 * Decompiled with CFR 0.152.
 */
package xml;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import xml.FormattedString;

public class FormattedText {
    protected ArrayList<FormattedString> lines = new ArrayList();
    protected Font startFont;
    protected boolean limited = false;

    public FormattedText(Graphics2D canvas, Font iStartFont, String iHtmlStr, Point2D bounds) {
        int lineSize = (int)bounds.getX();
        this.limited = lineSize > 0;
        canvas.setFont(iStartFont);
        String[] htmlLines = iHtmlStr.split("<br>");
        int i = 0;
        while (i < htmlLines.length) {
            this.lines.add(new FormattedString(canvas.getFont(), htmlLines[i]));
            if (this.limited) {
                FormattedString rest;
                do {
                    if ((rest = this.lines.get(this.lines.size() - 1).cut2size(canvas, lineSize)) == null) continue;
                    this.lines.add(rest);
                } while (rest != null);
            }
            ++i;
        }
        double dx = 0.0;
        double dy = 0.0;
        int i2 = 0;
        while (i2 < this.lines.size()) {
            Point2D lm = this.lines.get(i2).measureExts(canvas);
            if (lm.getX() > dx) {
                dx = lm.getX();
            }
            dy += lm.getY();
            ++i2;
        }
        bounds.setLocation(dx, dy);
    }

    public void draw(Graphics2D graphics, int sx, int sy) {
        Font old_font = graphics.getFont();
        graphics.setFont(this.startFont);
        Point2D.Double bounds = new Point2D.Double();
        int i = 0;
        while (i < this.lines.size()) {
            this.lines.get(i).draw(graphics, sx, sy, bounds);
            sy += (int)((Point2D)bounds).getY();
            ++i;
        }
        graphics.setFont(old_font);
    }
}

