/*
 * Decompiled with CFR 0.152.
 */
package xml;

import java.awt.Color;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.StringReader;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;

public class HTML2ACI
extends HTMLEditorKit.ParserCallback {
    private ParserDelegator parser;
    private StringBuilder plainText;
    private Font f;
    private List<AttrEntry> attrList = new ArrayList<AttrEntry>();
    private int startFontSize = 12;

    public HTML2ACI() {
        this.parser = new ParserDelegator();
        this.plainText = new StringBuilder("");
    }

    public AttributedString getACI(String iHtmlStr) {
        this.plainText.delete(0, this.plainText.length());
        this.attrList.clear();
        this.f = new Font("SansSerif", 0, this.startFontSize);
        StringReader reader = new StringReader(iHtmlStr);
        try {
            this.parser.parse(reader, this, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        AttributedString aci = new AttributedString(this.plainText.toString());
        this.addAttributesTo(aci);
        return aci;
    }

    @Override
    public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        pos = this.plainText.length();
        if (t.equals(HTML.Tag.B)) {
            this.attrList.add(new AttrEntry(t, TextAttribute.FONT, this.f.deriveFont(1), pos, -1));
        } else if (t.equals(HTML.Tag.I)) {
            this.attrList.add(new AttrEntry(t, TextAttribute.FONT, this.f.deriveFont(2), pos, -1));
        } else if (t.equals(HTML.Tag.U)) {
            this.attrList.add(new AttrEntry(t, TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, pos, -1));
        } else if (t.equals(HTML.Tag.SUB)) {
            HashMap<TextAttribute, Integer> m = new HashMap<TextAttribute, Integer>();
            m.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
            this.attrList.add(new AttrEntry(t, TextAttribute.FONT, this.f.deriveFont(m), pos, -1));
        } else if (t.equals(HTML.Tag.SUP)) {
            HashMap<TextAttribute, Integer> m = new HashMap<TextAttribute, Integer>();
            m.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
            this.attrList.add(new AttrEntry(t, TextAttribute.FONT, this.f.deriveFont(m), pos, -1));
        }
    }

    @Override
    public void handleEndTag(HTML.Tag t, int pos) {
        AttrEntry openAE;
        if ((t.equals(HTML.Tag.B) || t.equals(HTML.Tag.I) || t.equals(HTML.Tag.U) || t.equals(HTML.Tag.SUB) || t.equals(HTML.Tag.SUP)) && (openAE = this.getOpenAE(t)) != null) {
            openAE.endPos = this.plainText.length();
        }
    }

    @Override
    public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        if (t.equals(HTML.Tag.BR)) {
            this.plainText.append("\n");
        }
    }

    @Override
    public void handleText(char[] data, int pos) {
        this.plainText.append(data);
    }

    private AttrEntry getOpenAE(HTML.Tag aTag) {
        Iterator<AttrEntry> it = this.attrList.iterator();
        AttrEntry res = null;
        while (it.hasNext()) {
            AttrEntry next = it.next();
            if (!next.tag.equals(aTag) || !next.isOpen()) continue;
            res = next;
        }
        return res;
    }

    private void addAttributesTo(AttributedString as) {
        as.addAttribute(TextAttribute.FONT, this.f);
        as.addAttribute(TextAttribute.FOREGROUND, Color.BLACK);
        for (AttrEntry next : this.attrList) {
            if (next.isOpen()) continue;
            as.addAttribute(next.attr, next.attrValue, next.startPos, next.endPos);
        }
    }

    private class AttrEntry {
        public HTML.Tag tag;
        public TextAttribute attr;
        public Object attrValue;
        public int startPos;
        public int endPos;

        public AttrEntry(HTML.Tag iTag, TextAttribute iAttr, Object iAttrValue, int iStartPos, int iEndPos) {
            this.tag = iTag;
            this.attr = iAttr;
            this.attrValue = iAttrValue;
            this.startPos = iStartPos;
            this.endPos = iEndPos;
        }

        public boolean isOpen() {
            return this.endPos < this.startPos;
        }
    }
}

