/*
 * Decompiled with CFR 0.152.
 */
package xml;

import applet.Options;
import java.awt.Color;
import xml.FontSettings;
import xml.Helpers;

public class WindowData
implements Cloneable {
    private FontSettings font = new FontSettings();
    private double xmin = -10.0;
    private double xmax = 10.0;
    private double ymin = -8.89;
    private double ymax = 6.5;
    private int width = 400;
    private int height = 250;
    private Color bgColor = Color.decode("0xFFFFFF");

    public WindowData() {
    }

    public WindowData(FontSettings font) {
        this.setFont(font);
    }

    public FontSettings getFont() {
        return this.font;
    }

    public void setFont(FontSettings font) {
        this.font = font;
    }

    public void setFont(String fontName, int fontSize, int fontCharset, boolean bold, boolean italic, boolean underline, boolean strikeout) {
        this.font = new FontSettings(fontName, fontSize, fontCharset, bold, italic, underline, strikeout);
    }

    public Object clone() {
        WindowData obj = null;
        try {
            obj = (WindowData)super.clone();
            obj.font = (FontSettings)this.font.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public void setWindowCoordinates(double ixmin, double ixmax, double iymin, double iymax) {
        this.xmin = ixmin;
        this.xmax = ixmax;
        this.ymin = iymin;
        this.ymax = iymax;
    }

    public void setWidth(int iwidth) {
        this.width = iwidth;
    }

    public void setHeight(int iheight) {
        this.height = iheight;
    }

    public void setColor(String icolor) {
        this.bgColor = Color.decode("0x" + icolor.substring(3, 9));
    }

    public Color getColor() {
        return this.bgColor;
    }

    public String getHex8strColor() {
        return Helpers.toHexColorString(this.bgColor);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public double getXmin() {
        return this.xmin;
    }

    public double getXmax() {
        return this.xmax;
    }

    public double getYmin() {
        return this.ymin;
    }

    public double getYmax() {
        return this.ymax;
    }

    public void calculatePPCm() {
        double def_ppcm = 37.79527559055118;
        try {
            Options.ppcm = (double)this.width / (this.xmax - this.xmin);
            if (Math.abs((Options.ppcm - def_ppcm) / def_ppcm) < 0.01) {
                Options.ppcm = def_ppcm;
            }
            if (Math.abs((Options.aspect = (double)this.height / (this.ymax - this.ymin) / Options.ppcm) - 1.0) < 0.02) {
                Options.aspect = 1.0;
            }
        }
        catch (Exception e) {
            Options.ppcm = def_ppcm;
        }
    }

    public void cut2size(int drawWin_width, int drawWin_height) {
        this.calculatePPCm();
        this.width = drawWin_width;
        this.height = drawWin_height;
        this.xmax = this.xmin + (double)this.width / Options.ppcm;
        this.ymin = this.ymax - (double)this.height / (Options.ppcm * Options.aspect);
    }

    public void zoom(double act_drawWin_width, double act_drawWin_height) {
        double zfx = act_drawWin_width / (double)this.width;
        double zfy = act_drawWin_height / (double)this.height;
        if (Math.abs(Math.abs(zfx / zfy) - 1.0) < 0.15) {
            double zfac = (zfx + zfy) / 2.0;
            if (Math.abs(zfac - 1.0) > 0.001) {
                this.width = (int)act_drawWin_width;
                this.height = (int)act_drawWin_height;
                Options.ppcm *= zfac;
            } else {
                System.out.println("Unnecessary call to WindowData.zoom().");
            }
        } else {
            System.err.println("Call to WindowData.zoom() with unisotropic zoom factors: zfx = " + new Double(zfx).toString() + "; zfy = " + new Double(zfy).toString());
        }
    }
}

